% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampleSP.R
\name{resampleSP}
\alias{resampleSP}
\title{Resample snowprofile}
\usage{
resampleSP(x, h = 0.5, n = NULL)
}
\arguments{
\item{x}{snowprofile (or snowprofileLayers) object}

\item{h}{Sampling rate (i.e. constant depth increment) in centimeters, if given as scalar (default is 0.5 cm).
Layers smaller than the scalar h will not be resolved in the resampled profile.
Can also be a vector specifying the desired \emph{height} grid of the resampled profile (useful for non-constant increments).
But, be WARNED, that a meaningless grid will produce colorful but senseless output!}

\item{n}{Number of layers in resampled profile (optional). \emph{A given n will overrule a conflicting h!}}
}
\value{
resampled snowprofile with the same metadata as x, but resampled "layers". \strong{Note} that only
the following layer properties will be resampled: \code{height}, \code{hardness}, \code{gtype}, \code{ddate}.
If input was a snowprofileLayers object, the output will be, too.
}
\description{
Resample an individual snow profile onto a new depth-grid (i.e., height-grid).
}
\details{
This routine alters how the layer information of snow profiles is \emph{stored} without changing how the profiles appear.
Note, however, that only layer properties that are constant within the individual layers will be resampled:
i.e., \code{height}, \code{hardness}, \code{gtype}, \code{ddate} will be resampled. However, \code{temperature}, for example,
will not be resampled, because it is not constant within layers.
}
\examples{

## (1) constant sampling rate of 1 cm:
profileResampled <- resampleSP(SPpairs$A_modeled, h = 1.0)

## compare profile summary before and after resampling:
summary(SPpairs$A_modeled)[, c("hs", "nLayers")]
summary(profileResampled)[, c("hs", "nLayers", "changes")]
head(profileResampled$layers)

## compare profile plots before and after resampling (i.e., appear identical!)
opar <- par(no.readonly=TRUE)
par(mfrow = c(1, 2))
plot(SPpairs$A_modeled, main = "original", ylab = "Snow height")
plot(profileResampled, main = "resampled", ylab = "Snow height")
par(opar)

## (2) resample to 150 layers:
profileResampled <- resampleSP(SPpairs$A_manual, n = 150)
summary(profileResampled)[, c("hs", "nLayers", "changes")]
head(profileResampled$layers)


## (3) resample onto arbitrarily specified grid
## (issues a warning when the new-grid HS deviates too much from the original HS)
irregularGrid <- c(2 + cumsum(c(0, c(10, 15, 5, 1, 3, 30, 50))), 120)
profileResampled <- resampleSP(SPpairs$A_manual, h = irregularGrid)

}
\seealso{
\link{resampleSPpairs}, \link{mergeIdentLayers}
}
\author{
fherla
}
