% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{sfn_sites_in_folder}
\alias{sfn_sites_in_folder}
\title{list available sites in a db folder}
\usage{
sfn_sites_in_folder(folder = ".")
}
\arguments{
\item{folder}{Character vector of length 1 indicating the route to the
db folder}
}
\value{
A character vector with the site codes present in the folder, an
  error if the folder is not valid or does not contain any site data file.
}
\description{
Retrieves the site codes in the specified folder
}
\details{
If folder
}
\examples{
# Let's access the data in "folder". This typically is the folder where the
# sapflow data at the desired unit level is (i.e. "RData/plant"), but in this
# example we will create a temporal folder with some data to test the function
folder <- tempdir()
save(ARG_TRE, file = file.path(folder, 'ARG_TRE.RData'))
save(ARG_MAZ, file = file.path(folder, 'ARG_MAZ.RData'))
save(AUS_CAN_ST2_MIX, file = file.path(folder, 'AUS_EUC_ST2_MIX.RData'))

# lets see the sites
sites <- sfn_sites_in_folder(folder)

}
