% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{data_coverage}
\alias{data_coverage}
\title{data coverage}
\usage{
data_coverage(x, timestep, period_minutes)
}
\arguments{
\item{x}{a vector, usually a variable in the sapflow or environmental data.}

\item{timestep}{numeric value with the timestep in minutes}

\item{period_minutes}{numeric value with the period in minutes}
}
\value{
a single value (numeric) with the percentage of coverage for that
  variable
}
\description{
helper for sfn_metrics
}
\details{
This helper function calculates the coverage percentage in a vector, and is
designed to be used inside a dplyr summarise statement. It calculates the
coverage as the percentage of no NAs in the expected length of the summarising
period stated by the timestep.
}
\examples{
# data for one day, 60 minutes timestep (24 values) with a 75\% of coberture
x <- rep(c(1,2,3,NA), 6)
data_coverage(x, 60, 1440) # 75

}
