% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{time_at_events}
\alias{time_at_events}
\alias{max_time}
\alias{min_time}
\title{time at maximum/minimum}
\usage{
max_time(x, time)

min_time(x, time)
}
\arguments{
\item{x}{a numeric vector, usually a variable in the sapflow or environmental
data.}

\item{time}{a POSIXct or character vector with the TIMESTAMP values}
}
\value{
a single value (POSIXct) with the TIMESTAMP value.
}
\description{
helpers for sfn_metrics
}
\details{
These helper functions return the TIMESTAMP value at which the maximum value
for other variable occurs. It is designed to be used inside a dplyr summarise
statement.
}
\section{Functions}{
\itemize{
\item \code{max_time}: helper for sfn_metrics

\item \code{min_time}: helper for sfn_metrics
}}

\examples{
library(dplyr)
storms \%>\%
  group_by(year) \%>\%
  summarise(wind_max = max(wind),
            hour_at_max = sapfluxnetr:::max_time(wind, time = hour),
            wind_min = min(wind),
            hour_at_min = sapfluxnetr:::min_time(wind, time = hour))

}
\keyword{internal}
