% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_corpus_distribution.R
\name{tweet_corpus_distribution}
\alias{tweet_corpus_distribution}
\title{Twitter Corpus Distribution}
\usage{
tweet_corpus_distribution(DataFrameTidyScores, binwidth = 1,
  color = "black", fill = "white")
}
\arguments{
\item{DataFrameTidyScores}{DataFrame of Twitter Data that has been tidy'd and scored.}

\item{binwidth}{The width of the bins.  Default is 1.}

\item{color}{The user selected color to highlight the bins.}

\item{fill}{The interior color of the bins.}
}
\value{
A ggplot.
}
\description{
Determines the scores distribution for the entire Twitter data corpus.
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
score_data <- tweet_scores(DataFrameTidy = tidy_data, 
                           HT_Topic = "hashtag") 
Corp_Dist <- tweet_corpus_distribution(DataFrameTidyScores = score_data,
                                       binwidth = 1,
                                       color = "black", 
                                       fill = "white")
Corp_Dist
}
}
