## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
set.seed(42)

## -----------------------------------------------------------------------------
library(santoku)

chop(1:5, c(1,3,5))

chop(1:5, c(Low = 1, High = 3, 5))

## -----------------------------------------------------------------------------

ages <- sample(12:80, 20)
tab(ages, 
      c("Under 16" = 0, 16, 25, 35, 45, 55, "65 and over" = 65), 
      labels = lbl_discrete()
    )


## -----------------------------------------------------------------------------
x <- rnorm(10)
chopped <- chop_quantiles(x, 
                            c("Lower tail" = 0, 0.025, "Upper tail" = 0.975)
                          )
data.frame(x, chopped)

## -----------------------------------------------------------------------------

chop_mean_sd(x)

chop_mean_sd(x, raw = TRUE)

