% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.sandwich.r
\name{autoplot}
\alias{autoplot}
\alias{autoplot.sandwich.model}
\alias{autoplot.sandwich.ci}
\title{Plot interpolation results}
\usage{
\method{autoplot}{sandwich.model}(
  object,
  titles = c("Mean", "Standard Error"),
  labels = c("", ""),
  border_color = "darkgray",
  poly_fill_mean = c("white", "red"),
  poly_fill_se = c("white", "blue"),
  ...
)

\method{autoplot}{sandwich.ci}(
  object,
  titles = c("Confidence Interval (Lower Bound)", "Confidence Interval (Upper Bound)"),
  labels = c("", ""),
  border_color = "darkgray",
  poly_fill_ci = c("white", "red"),
  ...
)
}
\arguments{
\item{object}{A \code{sandwich.ci} object generated by \code{\link{sandwich.ci}}, or a \code{sandwich.model} object generated by \code{\link{sandwich.model}}.}

\item{titles}{A list of texts for the titles.}

\item{labels}{A list of texts for the legend labels.}

\item{border_color}{Color for outlines of the polygons.}

\item{poly_fill_mean}{A list of colors for low and high ends of the gradient in the mapping of means.}

\item{poly_fill_se}{A list of colors for low and high ends of the gradient in the mapping of standard errors.}

\item{...}{Ignored.}

\item{poly_fill_ci}{A list of colors for low and high ends of the gradient in the mapping of confidence intervals.}
}
\value{
A list of \code{ggplot} objects.
}
\description{
Plot the estimated mean, standard error, and confidence interval for each reporting unit.
}
\examples{
library(ggplot2)
data(hs.data)
hs.sw <- sandwich.model(object=hs.data, sampling.attr="Population", type="shp")
ggplot2::autoplot(object=hs.sw)

hs.sw.ci <- sandwich.ci(object=hs.sw, level=.95)
ggplot2::autoplot(object=hs.sw.ci)

}
\references{
Wang, J. F., Haining, R., Liu, T. J., Li, L. F., & Jiang, C. S. (2013). Sandwich estimation for multi-unit reporting on a stratified heterogeneous surface. \emph{Environment and Planning A}, 45(10), 2515-2534.
}
\seealso{
\code{\link{sandwich.model}}, \code{\link{sandwich.ci}}
}
