% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psmMergeSplit_base.R
\name{psmMergeSplit_base}
\alias{psmMergeSplit_base}
\title{Base Functionality for the psmMergeSplit Function}
\usage{
psmMergeSplit_base(
  partition,
  psm,
  logPosteriorPredictiveDensity = function(i, subset) 0,
  mass = 1,
  discount = 0,
  nUpdates = 1L,
  selectionWeights = NULL
)
}
\arguments{
\item{partition}{A numeric vector of cluster labels representing the current
partition.}

\item{psm}{A matrix of previously-calculated pairwise similarity
probabilities for each pair of data indices.}

\item{logPosteriorPredictiveDensity}{A function taking an index \eqn{i} (as a
numeric vector of length one) and a subset of integers \eqn{subset}, and
returning the natural logarithm of \eqn{p( y_i | y_subset )}, i.e., that
item's contribution to the log integrated likelihood given a subset of the
other items. The default value "turns off" the likelihood, resulting in
prior simulation (rather than posterior simulation).}

\item{mass}{A specification of the mass (concentration) parameter in the CRP
prior. Must be greater than the \code{-discount} argument.}

\item{discount}{A numeric value on the interval [0,1) corresponding to the
discount parameter in the two-parameter CRP prior.}

\item{nUpdates}{An integer giving the number of merge-split proposals before
returning. This has the effect of thinning the Markov chain.}

\item{selectionWeights}{A matrix or data frame whose first two columns are
the unique pairs of data indices, along with a column of weights
representing how likely each pair is to be selected at the beginning of
each merge-split update.}
}
\value{
\describe{ \item{partition}{A numeric vector giving the updated
  partition encoded using cluster labels.} \item{accept}{The acceptance rate
  of the Metropolis-Hastings proposals, i.e. the number of accepted proposals
  divided by \code{nUpdates}.} }
}
\description{
Merge-split proposals for conjugate "Chinese Restaurant Process" (CRP)
mixture models using sequentially-allocated elements. Allocation is performed
with weights derived from a previously-calculated pairwise similarity matrix.
}
\seealso{
\code{\link{psmMergeSplit}}
}
