% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b4S2.R
\name{b4S2}
\alias{b4S2}
\title{Statistical power for a hyphotesis testing on a single variance}
\usage{
b4S2(N, n, S2, S20, K = 0, DEFF = 1, conf = 0.95, power = 0.8,
  plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{n}{The sample size.}

\item{S2}{The value of the first estimated proportion.}

\item{S20}{The value of the null effect. Note that \code{S2} must be strictly smaller than \code{S2}.}

\item{K}{The excess kurtosis of the variable in the population.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default \code{conf = 0.95}.}

\item{power}{The statistical power. By default power = 0.80.}

\item{plot}{Optionally plot the power achieved for an specific sample size.}
}
\value{
The power of the test.
}
\description{
This function computes the power for a (right tail) test of variance
}
\details{
We note that the power is defined as: \deqn{1-\Phi(Z_{1-\alpha} - \frac{(D-P)}{\sqrt{\frac{DEFF}{n}(1-\frac{n}{N})(P (1-P))}})}
}
\examples{
b4S2(N = 100000, n = 400, S2 = 120, S20 = 100, K = 0, DEFF = 1)
b4S2(N = 100000, n = 400, S2 = 120, S20 = 100, K = 2, DEFF = 1)
b4S2(N = 100000, n = 400, S2 = 120, S20 = 100, K = 2, DEFF = 2.5, plot = TRUE)
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}

