% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Output_Tables.R
\name{multi_per_variable}
\alias{multi_per_variable}
\title{Returns a table based on the information of a \code{multi_compare_object} that
indicates the proportion of biased variables. It can be outputted as html or
LaTex Table, for example with the help of the \link[stargazer]{stargazer}
function.}
\usage{
multi_per_variable(
  multi_compare_objects,
  type = "coefs",
  label_df = NULL,
  lables_coefs = NULL,
  lables_models = NULL,
  ndigits = 1
)
}
\arguments{
\item{multi_compare_objects}{A object returned by the
\code{\link[sampcompR]{biv_compare}} function.}

\item{type}{The \code{type} of table, can either be \code{"coefs"},
\code{"models"}, or \code{"complete"}. When coefs is chosen, the average bias
of the coefficients is outputted, when models is chosen, the average bias
for the models is outputted, and when complete is chosen, both is outputted.}

\item{label_df}{A character vector containing labels for the data frames.}

\item{lables_coefs}{A character vector containing labels for the
coefficients.}

\item{lables_models}{A character vector containing labels for the
models.}

\item{ndigits}{Number of digits shown in the table.}
}
\value{
A matrix, that indicates the proportion of bias for every individual
coefficient or model for multivariate comparisons. This is given separately
for every comparison, as well as averaged over comparisons.
}
\description{
Returns a table based on the information of a \code{multi_compare_object} that
indicates the proportion of biased variables. It can be outputted as html or
LaTex Table, for example with the help of the \link[stargazer]{stargazer}
function.
}
\examples{

require(wooldridge)
card<-wooldridge::card

south <- card[card$south==1,]
north <- card[card$south==0,]
black <- card[card$black==1,]
white <- card[card$black==0,]

## use the function to plot the data
multi_data1 <- sampcompR::multi_compare(df = north, 
                                        bench = south,
                                        independent = c("age","fatheduc","motheduc","IQ"),
                                        dependent = c("educ","wage"),
                                        family = "ols") 

multi_data2 <- sampcompR::multi_compare(df = black, 
                                        bench = white,
                                        independent = c("age","fatheduc","motheduc","IQ"),
                                        dependent = c("educ","wage"),
                                        family = "ols") 

table<-sampcompR::multi_per_variable(multi_compare_objects = c("multi_data1","multi_data2"))
noquote(table)

}
