% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersal.R
\name{dispersal}
\alias{dispersal}
\alias{dispersal,samc,missing,missing,numeric,numeric-method}
\alias{dispersal,samc,RasterLayer,missing,numeric,numeric-method}
\alias{dispersal,samc,matrix,missing,numeric,numeric-method}
\alias{dispersal,samc,missing,missing,missing,missing-method}
\alias{dispersal,samc,missing,numeric,missing,missing-method}
\alias{dispersal,samc,missing,missing,numeric,missing-method}
\alias{dispersal,samc,missing,numeric,numeric,missing-method}
\alias{dispersal,samc,RasterLayer,missing,missing,missing-method}
\alias{dispersal,samc,matrix,missing,missing,missing-method}
\alias{dispersal,samc,RasterLayer,missing,numeric,missing-method}
\alias{dispersal,samc,matrix,missing,numeric,missing-method}
\title{Calculate dispersal metrics}
\usage{
dispersal(samc, occ, origin, dest, time)

\S4method{dispersal}{samc,missing,missing,numeric,numeric}(samc, dest, time)

\S4method{dispersal}{samc,RasterLayer,missing,numeric,numeric}(samc, occ, dest, time)

\S4method{dispersal}{samc,matrix,missing,numeric,numeric}(samc, occ, dest, time)

\S4method{dispersal}{samc,missing,missing,missing,missing}(samc)

\S4method{dispersal}{samc,missing,numeric,missing,missing}(samc, origin)

\S4method{dispersal}{samc,missing,missing,numeric,missing}(samc, dest)

\S4method{dispersal}{samc,missing,numeric,numeric,missing}(samc, origin, dest)

\S4method{dispersal}{samc,RasterLayer,missing,missing,missing}(samc, occ)

\S4method{dispersal}{samc,matrix,missing,missing,missing}(samc, occ)

\S4method{dispersal}{samc,RasterLayer,missing,numeric,missing}(samc, occ, dest)

\S4method{dispersal}{samc,matrix,missing,numeric,missing}(samc, occ, dest)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{occ}{A \code{\link[raster]{RasterLayer-class}} or \code{\link[base]{matrix}}.
The input type must match the input type used to create the
\code{\link{samc-class}} object, and must have the same properties as the
rest of the landscape data. See the \code{\link{check}} function for more
details.}

\item{origin}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to row \emph{i} of matrix \emph{P}
in the \code{\link{samc-class}} object.}

\item{dest}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to column \emph{j} of matrix \emph{P}
in the \code{\link{samc-class}} object.}

\item{time}{A positive integer or a vector of positive integers representing
time steps. Vectors must be ordered and contain no duplicates. Vectors may
not be used for metrics that return dense matrices. The maximum time step
value is capped at 10,000.}
}
\value{
A matrix, a vector, a list of vectors, or a numeric
}
\description{
Calculates the probability of individuals visiting locations
}
\details{
\eqn{\tilde{D}_{jt}=(\sum_{n=0}^{t-1}\tilde{Q}^n)\tilde{q}_j}
\itemize{
  \item \strong{dispersal(samc, dest, time)}

The result is a vector (single time step) or a list of vectors (multiple
time steps) where each element corresponds to a cell in the landscape,
and can be mapped back to the landscape using the \code{\link{map}} function.
Element \emph{k} is the probability of ever visiting a given destination,
if starting at any other location, within \emph{t} or fewer time steps.
}

\eqn{\psi^T\tilde{D}_{jt}}
\itemize{
  \item \strong{dispersal(samc, occ, dest, time)}

The result is a numeric (single time step) or a list of numerics (multiple
time steps) that is the unconditional probability of visiting a
given destination within \emph{t} or fewer time steps.
}

\eqn{D=(F-I)diag(F)^{-1}}
\itemize{
  \item \strong{dispersal(samc)}

The result is a matrix where element (\emph{i},\emph{j}) is the probability
that location \emph{j} is visited when starting in location \emph{i}.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use.

  \item \strong{dispersal(samc, origin)}

This function has not been optimized yet, and will not run.

  \item \strong{dispersal(samc, dest)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element \emph{i} is the probability that the
destination is visited when starting in location \emph{i}.

  \item \strong{dispersal(samc, origin, dest)}

The result is a numeric value that is the probability that an individual
starting at the origin visits the destination.
}

\eqn{\psi^TD}
\itemize{
  \item \strong{dispersal(samc, occ)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element \emph{j} is the unconditional
probability distribution of ever visiting location \emph{j}, regardless of
the initial location.

  \item \strong{dispersal(samc, occ, dest)}

The result is a numeric value that is the unconditional probability
distribution of ever visiting a given destination, regardless of the initial
location.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
