% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{salt}
\alias{salt}
\alias{salt_punctuation}
\alias{salt_letters}
\alias{salt_whitespace}
\alias{salt_digits}
\alias{salt_ocr}
\alias{salt_capitalization}
\alias{salt_decimal_commas}
\title{Salt vectors with common data problems}
\usage{
salt_punctuation(x, p = 0.2, n = 1)

salt_letters(x, p = 0.2, n = 1)

salt_whitespace(x, p = 0.2, n = 1)

salt_digits(x, p = 0.2, n = 1)

salt_ocr(x, p = 0.2, rep_p = 0.1)

salt_capitalization(x, p = 0.1, rep_p = 0.1)

salt_decimal_commas(x, p = 0.1, rep_p = 0.1)
}
\arguments{
\item{x}{A vector. This will always be coerced to character during salting.}

\item{p}{A number between 0 and 1. Percent of values in \code{x} that should be
salted.}

\item{n}{A positive integer. Number of times to add new values from
\code{insertions} into selected values in \code{x} manually supply your own list of
characters.}

\item{rep_p}{A number between 0 and 1. Probability that a given match should
be replaced in one of the selected values.}
}
\description{
These are easy-to-use wrapper functions that call either \link{salt_insert} (for
including new characters) or \link{salt_replace} (for salting that requires
replacement of specific characters) with sane defaults.
}
\details{
For a more fine-grained control over how characters are added and whether ,
see the documentation for \link{salt_insert}, \link{salt_substitute}, \link{salt_replace},
and \link{salt_delete}.
}
\section{Functions}{
\itemize{
\item \code{salt_punctuation}: Punctuation characters

\item \code{salt_letters}: Upper- and lower-case letters

\item \code{salt_whitespace}: Spaces

\item \code{salt_digits}: 0-9

\item \code{salt_ocr}: Replace some substrings with common OCR problems

\item \code{salt_capitalization}: Flip capitalization of letters

\item \code{salt_decimal_commas}: Flip decimals to commas and vice versa
}}

