% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-report.R
\name{parse_report_detail_rows}
\alias{parse_report_detail_rows}
\title{Format the detailed data from the "T!T" fact map in a tabular report}
\usage{
parse_report_detail_rows(
  content,
  fact_map_key = "T!T",
  labels = TRUE,
  guess_types = TRUE,
  bind_using_character_cols = deprecated()
)
}
\arguments{
\item{content}{\code{list}; the list returned from the \code{\link[httr]{content}}
function that parses the JSON response to a \code{list}.}

\item{fact_map_key}{\code{character}; string providing an index into each
section of a fact map, from which you can access summary and detailed data.
The pattern for the fact map keys varies by report format so it is important
to know what the \code{reportFormat} property of the target report is. See the
note below for more details.}

\item{labels}{\code{logical}; an indicator of whether the returned data should
be the label (i.e. formatted value) or the actual value. By default, the labels
are returned because these are what appear in the Salesforce dashboard and
more closely align with the column names. For example, "Account.Name" label
may be \code{"Account B"} and the value \code{0016A0000035mJEQAY}. The former
(label) more accurately reflects the "Account.Name".}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used, if \code{FALSE} then all fields will be returned
as character. This is helpful when \code{col_guess()} will mangle field values
in Salesforce that you'd like to preserve during translation into a \code{tbl_df},
like numeric looking values that must be preserved as strings ("48.0").}

\item{bind_using_character_cols}{\code{logical}; an indicator of whether to
cast the data to all character columns to ensure that \code{\link[dplyr:bind]{bind_rows}}
does not fail because two paginated recordsets have differing datatypes for the
same column. Set this to \code{TRUE} rarely, typically only when having this
set to \code{FALSE} returns an error or you want all columns in the data to be
character.}
}
\value{
\code{tbl_df}; a data frame representing the detail rows of a parsed
report result HTTP response where the rows represent each row in the report
and the columns represent the detail columns.
}
\description{
This function accepts a list that is directly returned by the API and further
parses it to return a single \code{tbl_df} representing the detail rows and
columns of the report without any filters, aggregates, or totals.
}
\note{
Below are the fact map key patterns for three report types:
\describe{
\item{TABULAR}{\code{T!T}: The grand total of a report. Both record data
values and the grand total are represented by this key.}
\item{SUMMARY}{\code{<First level row grouping_second level row grouping_third 
  level row grouping>!T}: T refers to the row grand total.}
\item{MATRIX}{\code{<First level row grouping_second level row grouping>!<First 
  level column grouping_second level column grouping>.}}
}

Each item in a row or column grouping is numbered starting with 0. Here are
some examples of fact map keys:

\describe{
\item{0!T}{The first item in the first-level grouping.}
\item{1!T}{The second item in the first-level grouping.}
\item{0_0!T}{The first item in the first-level grouping and the first item
in the second-level grouping.}
\item{0_1!T}{The first item in the first-level grouping and the second item
in the second-level grouping.}
}

This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
