% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_get_updated}
\alias{sf_get_updated}
\title{Get Updated Records from a Timeframe}
\usage{
sf_get_updated(object_name, start, end, verbose = FALSE)
}
\arguments{
\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{start}{\code{date} or \code{datetime}; starting datetime of the timespan
for which to retrieve the data.}

\item{end}{\code{date} or \code{datetime}; ending datetime of the timespan for
which to retrieve the data.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Retrieves the list of individual records that have been inserted or updated
within the given timespan in the specified object.
}
\note{
This API ignores the seconds portion of the supplied datetime values.
}
\examples{
\dontrun{
# get all updated Contact records from midnight until now
updated_recs <- sf_get_updated("Contact", Sys.Date(), Sys.time())
}
}
