% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_get_job_records_bulk}
\alias{sf_get_job_records_bulk}
\title{Returning the Details of a Bulk API Job}
\usage{
sf_get_job_records_bulk(
  job_id,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  record_types = c("successfulResults", "failedResults", "unprocessedRecords"),
  combine_record_types = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{record_types}{\code{character}; one or more types of records to retrieve from
the results of running the specified job}

\item{combine_record_types}{\code{logical}; indicating for Bulk 2.0 jobs whether the
successfulResults, failedResults, and unprocessedRecords should be stacked
together by binding the rows.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} or \code{list} of \code{tbl_df}, formatted by Salesforce,
with information containing the success or failure or certain rows in a submitted job
}
\description{
This function returns detailed (row-level) information on a job
which has already been submitted completed (successfully or not).
}
\note{
With Bulk 2.0 the order of records in the response is not guaranteed to
match the ordering of records in the original job data.
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
input_data <- tibble(Name=c("Test Account 1", "Test Account 2"))
batches_result <- sf_create_batches_bulk(job_info$id, input_data)
# pause a few seconds for operation to finish. Wait longer if job is not complete.
Sys.sleep(3)
# check status using - sf_get_job_bulk(job_info$id)
job_record_details <- sf_get_job_records_bulk(job_id=job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
