% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_get_all_query_jobs_bulk}
\alias{sf_get_all_query_jobs_bulk}
\title{Get All Bulk API Query Jobs}
\usage{
sf_get_all_query_jobs_bulk(
  parameterized_search_list = list(isPkChunkingEnabled = NULL, jobType = NULL,
    concurrencyMode = NULL),
  next_records_url = NULL,
  api_type = c("Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{parameterized_search_list}{list; a list of parameters to be added as part
of the URL query string (i.e. after a question mark ("?") so that the result
only returns information about jobs that meet that specific criteria. For
more information, read the note below and/or the Salesforce documentation
\href{https://developer.salesforce.com/docs/atlas.en-us.api_bulk_v2.meta/api_bulk_v2/query_get_all_jobs.htm}{here}.}

\item{next_records_url}{character (leave as NULL); a string used internally
by the function to paginate through to more records until complete}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{tbl_df} of parameters defining the details of all bulk jobs
}
\description{
This function retrieves details about all Bulk query jobs in the org.
}
\note{
parameterized_search_list elements that can be set to filter the results:
\itemize{
\item{isPkChunkingEnabled}{A logical either TRUE or FALSE. TRUE only returns
information about jobs where PK Chunking has been enabled.}
\item{jobType}{A character string to return jobs matching the specified type.
Must be one of: "BigObjectIngest", "Classic", "V2Query". Classic corresponds
to Bulk 1.0 API jobs and V2Query corresponds to the Bulk 2.0 API jobs.}
\item{concurrencyMode}{A character string to return jobs matching the specified
concurrency mode. Must be one of: "serial" or "parallel", but only "serial"
is currently supported.}
}
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
all_query_jobs_info <- sf_get_all_query_jobs_bulk()
# just the Bulk API 2.0 query jobs
all_query_jobs_info <- sf_get_all_query_jobs_bulk(parameterized_search_list=list(jobType='V2Query'))
# just the Bulk API 1.0 query jobs
all_query_jobs_info <- sf_get_all_query_jobs_bulk(parameterized_search_list=list(jobType='Classic'))
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_bulk_v2.meta/api_bulk_v2/get_all_jobs.htm}
}
