% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sf_download_attachment}
\alias{sf_download_attachment}
\title{Download an Attachment}
\usage{
sf_download_attachment(body, name, path = ".")
}
\arguments{
\item{body}{character; a URL path to the body of the attachment in Salesforce, typically 
retrieved via query on the Attachment object}

\item{name}{character; the name of the file you would like to save the content to}

\item{path}{character; a directory path where to create file, defaults to the current directory.}
}
\description{
This function will allow you to download an attachment to disk based on the 
attachment body, file name, and path.
}
\examples{
\dontrun{
queried_attachments <- sf_query("SELECT Body, Name 
                                 FROM Attachment 
                                 WHERE ParentId = '0016A0000035mJ5'")
mapply(sf_download_attachment, queried_attachments$Body, queried_attachments$Name)
}
}
