% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-distributions.r
\name{dnorm}
\alias{dnorm}
\alias{dnorm.dual}
\title{Normal distribution}
\usage{
dnorm(x, mean = 0, sd = 1, log = FALSE)

dnorm.dual(x, mean = 0, sd = 1, log = FALSE)
}
\arguments{
\item{x}{vector of values}

\item{mean}{vector of means}

\item{sd}{vector of standard deviations}

\item{log}{logical. If TRUE, log of densities are returned}
}
\value{
a dual object.
}
\description{
Density for the normal distribution, accepting
objects of class 'dual'
}
\details{
`dnorm.dual` will make straightfoward a computation (in R), that 
works both with numeric or dual objects. `dnorm` will call `dnorm.dual`
if any of the objects is of class dual, or `stats::dnorm` is all objects
are of class numeric. As `stats::dnorm` is in written in C it is factor.

If you care for performance, use `stats::dnorm` directly for non dual numbers,
and `dnorm.dual` for dual numbers.
}
\examples{
x <- dual(0)
dnx <- dnorm(x)
dnx
d(dnx)

}
