% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateStandard.R
\name{evaluateStandard}
\alias{evaluateStandard}
\title{Evaluate a data set against a data standard}
\usage{
evaluateStandard(data, standard, includeFields = TRUE, domain = "labs")
}
\arguments{
\item{data}{data.frame to evaluate}

\item{standard}{standard to evaluate}

\item{includeFields}{should field level data be evaluated?}

\item{domain}{data domain. "labs" only for now.}
}
\value{
a list describing to what degree the data set matches the data standard. The "match" property describes compliance with the standard as "full", "partial" or "none". The "checks" property is a list of the data elements expected for the standard and whether they are "valid" in the given data set. "total_checks", "valid_checks" and "invalid_checks" provide counts of the specified checks. "match_percent" is calculated as valid_checks/total_checks.
}
\description{
Determines whether the required data elements in a data standard are found in a given data frame
}
\examples{
safetyGraphics:::evaluateStandard(data=adlbc, standard="adam") # Match is TRUE
safetyGraphics:::evaluateStandard(data=adlbc, standard="sdtm") # Match is FALSE

}
\keyword{internal}
