% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{decrypt_string}
\alias{decrypt_string}
\title{Decrypt an encrypted string}
\usage{
decrypt_string(encryptedString, key = "pass", method = "symmetric")
}
\arguments{
\item{encryptedString}{A string(character vector of length 1) without embedded NULL to be decrypted.}

\item{key}{A string without embbeded NULL. Default is 'pass'.}

\item{method}{Currently, a stub. It should be 'symmetric'(default)}
}
\value{
A decrypted string
}
\description{
\code{encrypt_string} encrypts a string as a string and
  \code{decrypt_string} decrypts the encrypted string(encrypted using
  \code{encrypt_string})
}
\examples{
temp <- encrypt_string("hello, how are you", key = "secret")
all(
  is.character(temp)
  , decrypt_string(temp, "secret") == "hello, how are you"
  , class(try(decrypt_string(temp, "nopass"), silent = TRUE)) == "try-error")

}
