% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{saemix}
\alias{estep}
\alias{initialiseMainAlgo}
\alias{mstep}
\alias{saemix}
\title{Stochastic Approximation Expectation Maximization (SAEM) Algorithm}
\usage{
saemix(model, data, control = list())
}
\arguments{
\item{model}{an object of class SaemixModel, created by a call to the
function \code{\link{saemixModel}}}

\item{data}{an object of class SaemixData, created by a call to the function
\code{\link{saemixData}}}

\item{control}{a list of options, see \code{\link{saemixControl}}}
}
\value{
An object of class SaemixObject containing the results of the fit of
the data by the non-linear mixed effect model. A summary of the results is
printed out to the terminal, and, provided the appropriate options have not
been changed, numerical and graphical outputs are saved in a directory.
}
\description{
SAEM algorithm perform parameter estimation for nonlinear mixed effects
models without any approximation of the model (linearization, quadrature
approximation, . . . )
}
\details{
The SAEM algorithm is a stochastic approximation version of the standard EM
algorithm proposed by Kuhn and Lavielle (see reference). Details of the
algorithm can be found in the pdf file accompanying the package.
}
\examples{
data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA,
   name.group=c("Id"),name.predictors=c("Dose","Time"),
   name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
   units=list(x="hr",y="mg/L", covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) {
	  dose<-xidep[,1]
	  tim<-xidep[,2]
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption",
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

 \donttest{
# Not run (strict time constraints for CRAN)
saemix.fit<-saemix(saemix.model,saemix.data,list(seed=632545,directory="newtheo",
 save=FALSE,save.graphs=FALSE))

# Prints a summary of the results
 print(saemix.fit)

# Outputs the estimates of individual parameters
 psi(saemix.fit)

# Shows some diagnostic plots to evaluate the fit
 plot(saemix.fit)
 }
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}},
\code{\link{SaemixObject}}, \code{\link{saemixControl}},
\code{\link{plot.saemix}}
}
\keyword{models}

