% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/func_plots.R
\name{default.saemix.plots}
\alias{advanced.gof}
\alias{basic.gof}
\alias{covariate.fits}
\alias{default.saemix.plots}
\alias{individual.fits}
\title{Wrapper functions to produce certain sets of default plots}
\usage{
default.saemix.plots(saemixObject, ...)
}
\arguments{
\item{saemixObject}{an object returned by the \code{\link{saemix}} function}

\item{\dots}{optional arguments passed to the plots}
}
\value{
Depending on the type argument, the following plots are produced:
\itemize{
\item{default.saemix.plots}{ by default, the following plots are
produced: a plot of the data, convergence plots, plot of the likelihood by
importance sampling (if computed), plots of observations versus predictions,
scatterplots and distribution of residuals, boxplot of the random effects,
correlations between random effects, distribution of the parameters, VPC}
\item{basic.gof}{ basic goodness-of-fit plots: convergence plots, plot of
the likelihood by importance sampling (if computed), plots of observations
versus predictions}
\item{advanced.gof}{ advanced goodness-of-fit plots:
scatterplots and distribution of residuals, VPC,...}
\item{covariate.fits}{
plots of all estimated parameters versus all covariates in the dataset}
\item{individual.fits}{ plots of individual predictions (line) overlayed on
individual observations (dots) for all subjects in the dataset}
}
}
\description{
These functions produce default sets of plots, corresponding to diagnostic
or individual fits.
}
\details{
These functions are wrapper functions designed to produce default sets of
plots to help the user assess their model fits.
}
\examples{
data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA,
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) {
	  dose<-xidep[,1]
	  tim<-xidep[,2]
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption",
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

# Reducing the number of iterations due to time constraints for CRAN
saemix.options<-list(seed=632545,save=FALSE,save.graphs=FALSE,nbiter.saemix=c(100,100))

saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)

default.saemix.plots(saemix.fit)

# Not run (time constraints for CRAN)
# basic.gof(saemix.fit)

# Not run (time constraints for CRAN)
# advanced.gof(saemix.fit)

individual.fits(saemix.fit)
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{saemix}}, \code{\link{saemix.plot.data}},
\code{\link{saemix.plot.setoptions}}, \code{\link{plot.saemix}}
}
\keyword{plots}

