% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{ranef}
\alias{ranef}
\alias{random.effects}
\alias{ranef.NER}
\alias{random.effects.NER}
\title{Extract random effects of 'saeTrafo' object}
\usage{
\method{ranef}{NER}(object, ...)

\method{random.effects}{NER}(object, ...)
}
\arguments{
\item{object}{an object of type "NER".}

\item{...}{additional arguments that are not used in this method.}
}
\value{
A vector containing the estimated random effects at domain level is
returned.
}
\description{
Method \code{ranef.NER} extracts the random effects from an 'saeTrafo' object.
}
\details{
The alias \code{random.effects} can also be used instead of
\code{ranef}. The generic function \code{ranef} is imported from package
\pkg{nlme} and re-exported to make the S3-methods available, even though the
\pkg{nlme} package itself is not loaded or attached. For default
documentation, see \code{\link[nlme]{random.effects}}.
}
\examples{
# Example to extract random effects

# Load Data
data("eusilcA_smp")
data("pop_area_size")
data("pop_mean")
data("pop_cov")

# Nested error regression model
NER_model <- NER_Trafo(fixed = eqIncome ~ gender + eqsize + cash +
                       self_empl + unempl_ben + age_ben + surv_ben +
                       sick_ben + dis_ben + rent + fam_allow + house_allow +
                       cap_inv + tax_adj,
                       smp_domains = "district",
                       pop_area_size = pop_area_size,
                       pop_mean = pop_mean, pop_cov = pop_cov,
                       smp_data = eusilcA_smp)

ranef(NER_model)
}
\seealso{
\code{\link{NER_Trafo}}, \code{\link[nlme]{random.effects}}
}
