% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dnbeta.r
\name{dnbeta}
\alias{ddnbeta}
\alias{dnbeta}
\alias{pdnbeta}
\alias{qdnbeta}
\alias{rdnbeta}
\title{The doubly non-central Beta distribution.}
\usage{
ddnbeta(x, df1, df2, ncp1, ncp2, log = FALSE, order.max=6)

pdnbeta(q, df1, df2, ncp1, ncp2, lower.tail = TRUE, log.p = FALSE, order.max=6)

qdnbeta(p, df1, df2, ncp1, ncp2, lower.tail = TRUE, log.p = FALSE, order.max=6)

rdnbeta(n, df1, df2, ncp1, ncp2)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{df1,df2}{the degrees of freedom for the numerator and denominator.
We do \emph{not} recycle these versus the \code{x,q,p,n}.}

\item{ncp1,ncp2}{the non-centrality parameters for the numerator and denominator.
We do \emph{not} recycle these versus the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
 \eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{ddnbeta} gives the density, \code{pdnbeta} gives the
distribution function, \code{qdnbeta} gives the quantile function,
and \code{rdnbeta} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the doubly non-central Beta distribution.
}
\details{
Suppose \eqn{x_i \sim \chi^2\left(\delta_i,\nu_i\right)}{x_i ~ X^2(delta_i,v_i)}
be independent non-central chi-squares for \eqn{i=1,2}{i=1,2}.
Then
\deqn{Y = \frac{x_1}{x_1 + x_2}}{Y = x_1 / (x_1 + x_2)}
takes a doubly non-central Beta distribution with degrees of freedom
\eqn{\nu_1, \nu_2}{v_1, v_2} and non-centrality parameters
\eqn{\delta_1,\delta_2}{delta_1,delta_2}.
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.
}
\examples{
rv <- rdnbeta(500, df1=100,df2=500,ncp1=1.5,ncp2=12)
d1 <- ddnbeta(rv, df1=100,df2=500,ncp1=1.5,ncp2=12)
\dontrun{
plot(rv,d1)
}
p1 <- ddnbeta(rv, df1=100,df2=500,ncp1=1.5,ncp2=12)
# should be nearly uniform:
\dontrun{
plot(ecdf(p1))
}
q1 <- qdnbeta(ppoints(length(rv)), df1=100,df2=500,ncp1=1.5,ncp2=12)
\dontrun{
qqplot(x=rv,y=q1)
}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\seealso{
(doubly non-central) F distribution functions,
\code{\link{ddnf}, \link{pdnf}, \link{qdnf}, \link{rdnf}}.
}
\keyword{distribution}

