% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapcurves_calc.R
\name{mapcurves_calc}
\alias{mapcurves_calc}
\alias{mapcurves_calc.sf}
\alias{mapcurves_calc.RasterLayer}
\title{Mapcurves calculation}
\usage{
mapcurves_calc(x, y, x_name, y_name, precision = NULL)

\method{mapcurves_calc}{sf}(x, y, x_name, y_name, precision = NULL)

\method{mapcurves_calc}{RasterLayer}(x, y, x_name = NULL,
  y_name = NULL, precision = NULL)
}
\arguments{
\item{x}{An object of class \code{sf} with a \code{POLYGON} or \code{MULTIPOLYGON} geometry type.}

\item{y}{An object of class \code{sf} with a \code{POLYGON} or \code{MULTIPOLYGON} geometry type.}

\item{x_name}{A name of the column with regions/clusters names.}

\item{y_name}{A name of the column with regions/clusters names.}

\item{precision}{numeric, or object of class \code{units} with distance units (but see details); see \link{st_as_binary} for how to do this.}
}
\value{
A list with four elements:
\itemize{
\item "map1" - the sf object containing the first map used for calculation of GOF
\item "map2" - the sf object containing the second map used for calculation of GOF
\item "ref_map" - the map used as a reference ("x" or "y")
\item "gof" - the Mapcurves's goodness of fit value
}
}
\description{
It calculates the Mapcurves's goodness-of-fit (GOF)
}
\examples{
library(sf)
data("regions1")
data("regions2")

mc = mapcurves_calc(x = regions1, y = regions2, x_name = z, y_name = z)
mc

plot(mc$map1)
plot(mc$map2)

}
\references{
Hargrove, William W., Forrest M. Hoffman, and Paul F. Hessburg.
"Mapcurves: a quantitative method for comparing categorical maps."
Journal of Geographical Systems 8.2 (2006): 187.
}
