\name{ColorBar}
\alias{ColorBar}
\title{Draws a Color Bar}
\description{
Generates a color bar to use as colouring function for map plots and optionally draws it (horizontally or vertically) to be added to map multipanels or plots. It is possible to draw triangles at the ends of the colour bar to represent values that go beyond the range of interest. A number of options is provided to adjust the colours and the position and size of the components. The drawn colour bar spans a whole figure region and is compatible with figure layouts.\cr\cr
The generated colour bar consists of a set of breaks that define the length(brks) - 1 intervals to classify each of the values in each of the grid cells of a two-dimensional field. The corresponding grid cell of a given value of the field will be coloured in function of the interval it belongs to.\cr\cr
The only mandatory parameters are 'var_limits' or 'brks' (in its second format, see below).
}
\usage{
ColorBar(brks = NULL, cols = NULL, vertical = TRUE,
         subsampleg = NULL, bar_limits = NULL, var_limits = NULL,
         triangle_ends = NULL, col_inf = NULL, col_sup = NULL, 
         color_fun = clim.palette(), plot = TRUE, draw_ticks = TRUE, 
         draw_separators = FALSE, triangle_ends_scale = 1, 
         extra_labels = NULL, title = NULL, title_scale = 1, 
         label_scale = 1, tick_scale = 1, 
         extra_margin = rep(0, 4), label_digits = 4, ...)
}
\arguments{
  \item{brks}{
'brks' can be provided in two formats:\cr
a) A single value with the number of breaks to be generated automatically, between the minimum and maximum specified in 'var_limits' (both inclusive). Hence the parameter 'var_limits' is mandatory if 'brks' is provided with this format. If 'bar_limits' is additionally provided, values only between 'bar_limits' will be generated. The higher the value of 'brks', the smoother the plot will look.\cr
b) A vector with the actual values of the desired breaks. Values will be reordered by force to ascending order. If provided in this format, no other parameters are required to generate/plot the colour bar.\cr\cr

This parameter is optional if 'var_limits' is specified. If 'brks' not specified but 'cols' is specified, it will take as value length(cols) + 1. If 'cols' is not specified either, 'brks' will take 21 as value.\cr\cr
  }
  \item{cols}{
Vector of length(brks) - 1 valid colour identifiers, for each interval defined by the breaks. This parameter is optional and will be filled in with a vector of length(brks) - 1 colours generated with the function provided in 'color_fun' (\code{clim.colors} by default).\cr
'cols' can have one additional colour at the beginning and/or at the end with the aim to colour field values beyond the range of interest represented in the colour bar. If any of these extra colours is provided, parameter 'triangle_ends' becomes mandatory in order to disambiguate which of the ends the colours have been provided for.\cr
  }
  \item{vertical}{
TRUE/FALSE for vertical/horizontal colour bar (disregarded if plot = FALSE).
  }
  \item{subsampleg}{
The first of each subsampleg breaks will be ticked on the colorbar.\cr
Takes by default an approximation of a value that yields a readable tick arrangement (extreme breaks always ticked). If set to 0 or lower, no labels are drawn. See the code of the function for details or use 'extra_labels' for customized tick arrangements.
  }
  \item{bar_limits}{
Vector of two numeric values with the extremes of the range of values represented in the colour bar. If 'var_limits' go beyond this interval, the drawing of triangle extremes is triggered at the corresponding sides, painted in 'col_inf' and 'col_sup'. Either of them can be set as NA and will then take as value the corresponding extreme in 'var_limits' (hence a triangle end won't be triggered for these sides). Takes as default the extremes of 'brks' if available, else the same values as 'var_limits'.
  }
  \item{var_limits}{
Vector of two numeric values with the minimum and maximum values of the field to represent. These are used to know whether to draw triangle ends at the extremes of the colour bar and what colour to fill them in with. If not specified, take the same value as the extremes of 'brks'. Hence the parameter 'brks' is mandatory if 'var_limits' is not specified.
  }
  \item{triangle_ends}{
Vector of two logical elements, indicating whether to force the drawing of triangle ends at each of the extremes of the colour bar. This choice is automatically made from the provided 'brks', 'bar_limits', 'var_limits', 'col_inf' and 'col_sup', but the behaviour can be manually forced to draw or not to draw the triangle ends with this parameter. If 'cols' is provided, 'col_inf' and 'col_sup' will take priority over 'triangle_ends' when deciding whether to draw the triangle ends or not.
  }
  \item{col_inf}{
Colour to fill the inferior triangle end with. Useful if specifying colours manually with parameter 'cols', to specify the colour and to trigger the drawing of the lower extreme triangle, or if 'cols' is not specified, to replace the colour automatically generated by ColorBar().
  }
  \item{col_sup}{
Colour to fill the superior triangle end with. Useful if specifying colours manually with parameter 'cols', to specify the colour and to trigger the drawing of the upper extreme triangle, or if 'cols' is not specified, to replace the colour automatically generated by ColorBar().
  }
  \item{color_fun}{
Function to generate the colours of the color bar. Must take an integer and must return as many colours. The returned colour vector can have the attribute 'na_color', with a colour to draw NA values. This parameter is set by default to clim.palette().
  }
  \item{plot}{
Logical value indicating whether to only compute its breaks and colours (FALSE) or to also draw it on the current device (TRUE).
  }
  \item{draw_ticks}{
Whether to draw ticks for the labels along the colour bar (TRUE) or not (FALSE). TRUE by default. Disregarded if 'plot = FALSE'.
  }
  \item{draw_separators}{
Whether to draw black lines in the borders of each of the colour rectancles of the colour bar (TRUE) or not (FALSE). FALSE by default. Disregarded if 'plot = FALSE'.
  }
  \item{triangle_ends_scale}{
Scale factor for the drawn triangle ends of the colour bar, if drawn at all. Takes 1 by default (rectangle triangle proportional to the thickness of the colour bar). Disregarded if 'plot = FALSE'.
  }
  \item{extra_labels}{
Numeric vector of extra labels to draw along axis of the colour bar. The number of provided decimals will be conserved. Disregarded if 'plot = FALSE'.
  }
  \item{title}{
Title to draw on top of the colour bar, most commonly with the units of the represented field in the neighbour figures. Empty by default.
  }
  \item{title_scale}{
Scale factor for the 'title' of the colour bar. Takes 1 by default.
  }
  \item{label_scale}{
Scale factor for the labels of the colour bar. Takes 1 by default.
  }
  \item{tick_scale}{
Scale factor for the length of the ticks of the labels along the colour bar. Takes 1 by default.
  }
  \item{extra_margin}{
Extra margins to be added around the colour bar, in the format c(y1, x1, y2, x2). The units are margin lines. Takes rep(0, 4) by default.
  }
  \item{label_digits}{
Number of significant digits to be displayed in the labels of the colour bar, usually to avoid too many decimal digits overflowing the figure region. This does not have effect over the labels provided in 'extra_labels'. Takes 4 by default.
  }
  \item{...}{
Arguments to be passed to the method. Only accepts the following graphical parameters:

adj ann ask bg bty cex.lab cex.main cex.sub cin col.axis col.lab col.main col.sub cra crt csi cxy err family fg fig fin font font.axis font.lab font.main font.sub lend lheight ljoin lmitre lty lwd mai mex mfcol mfrow mfg mkh oma omd omi page pch pin plt pty smo srt tck tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog

For more information about the parameters see `par`
  }
}
\value{
  \item{brks}{
Breaks used for splitting the range in intervals.
  }
  \item{cols}{
Colours generated for each of the length(brks) - 1 intervals. Always of length length(brks) - 1.
  }
  \item{col_inf}{
Colour used to draw the lower triangle end in the colour bar (NULL if not drawn at all).
  }
  \item{col_sup}{
Colour used to draw the upper triangle end in the colour bar (NULL if not drawn at all).
  }
}
\examples{
cols <- c("dodgerblue4", "dodgerblue1", "forestgreen", "yellowgreen", "white",
          "white", "yellow", "orange", "red", "saddlebrown")
lims <- seq(-1, 1, 0.2)
ColorBar(lims, cols)
}
\author{
History:\cr
0.1  -  2012-04  (V. Guemas, \email{virginie.guemas at bsc.es})  -  Original code\cr
0.2  -  2013-04  (I. Andreu-Burillo, \email{isabel.andreu-burillo at bsc.es})  -  Vert option\cr
1.0  -  2013-09  (N. Manubens, \email{nicolau.manubens at bsc.es})  -  Formatting to CRAN\cr
1.1  -  2013-09  (C. Prodhomme, \email{chloe.prodhomme at bsc.es})  -  Add cex option\cr
1.2  -  2016-08  (N. Manubens, \email{nicolau.manubens at bsc.es})  -  New ColorBar\cr
                 (V. Torralba, \email{veronica.torralba at bsc.es})
}
\keyword{dplot}
