% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qq-plot.R
\name{qqnorm_spss}
\alias{qqnorm_spss}
\title{SPSS like QQ-plot}
\usage{
qqnorm_spss(x, standardize = FALSE, method = 1, ties.method = "average")
}
\arguments{
\item{x}{A numeric vector.}

\item{standardize}{Whether the quantiles of the standardized values
should be displayed. The default is to display the quantiles using the
original data.}

\item{method}{The method used to assign probabilties for the
ranks that are then converted into quantiles.
The following methods are implemented (see Castillo-Gutiérrez, Lozano-Aguilera,
& Estudillo-Martínez, 2012):
\code{1 =} Blom (default), \code{2 =} Rankit / Hazen, \code{3 =} Tukey,
\code{4 =} Van der Waerden / Weibull, \code{5 =} Benard and Bos-Levenbach,
\code{6 =} Gringorten and \code{7 =} Yu and Huang.}

\item{ties.method}{Method to assign ranks to ties. One of
 \code{"average", "first", "random", "max", "min"}. See \code{ties.method}
 argument from \code{\link{rank}} for more details.}
}
\value{
An list object of class \code{qqnorm.spss} with the
 following elements:
 \item{x}{The orginal data}
 \item{y}{Corresponding quantiles in original scaling}
 \item{x.std}{Standardized values}
 \item{y.std}{Corresponding quantiles for standardized values}
 \item{method.name}{Name of the method to assign probabilities to ranks}
 \item{ties.method}{Method to treat ties}
 \item{xname}{Name of the variable used to produce the plot}
}
\description{
The QQ-plot in SPSS and R looks very different. The points
points and the QQ-line are positioned differently.
\code{qqnorm_spss} implements a version of the QQ-plot that resembles
the SPSS version. The function returns an object containing the
processed data. The output can be plotted using the function \code{plot}
and \code{ggplot}. The parameters that can be passed to the
plotting functions are documented in \code{\link{plot.qqnorm.spss}} and
\code{\link{ggplot.qqnorm.spss}}.
}
\section{TODO}{

Check output against SPSS results.
}
\examples{
require(ggplot2)

set.seed(0)
x <- sample(0:9, 100, rep=TRUE)

### SPSS like

# Standard QQ-plot
qq <- qqnorm_spss(x, 1)
plot(qq)  
ggplot(qq)

qq <- qqnorm_spss(x, 1, standardize=TRUE)
plot(qq, l.col="red")  
ggplot(qq, line=FALSE)

# Detrended QQ-plot (plottype=2)
plot(qq, plottype=2)  
ggplot(qq, plottype=2)

### R
qqnorm(x, datax=TRUE)
qqline(x, datax=TRUE)


}
\references{
Castillo-Gutiérrez, S., Lozano-Aguilera, E., & Estudillo-Martínez, M. D. (2012).
   Selection of a Plotting Position for a Normal Q-Q Plot. R Script.
   \emph{Journal of Communication and Computer, 9}(3), 243–250.
}

