% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikF}
\alias{llikF}
\title{log likelihood and derivatives for F distribution}
\usage{
llikF(x, df1, df2, full = FALSE)
}
\arguments{
\item{x}{variable that is distributed by f distribution}

\item{df1, df2}{degrees of freedom.  \code{Inf} is allowed.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with \code{dDf1} and \code{dDf2}
that has the derivatives with respect to the \code{df1}/\code{df2} parameters at
the observation time-point
}
\description{
log likelihood and derivatives for F distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikF()} but you have to
use the x and rate arguments.  You can also get the derivative of \code{df1} and \code{df2} with
\code{llikFDdf1()} and \code{llikFDdf2()}.
}
\examples{

\donttest{
x <- seq(0.001, 5, length.out = 100)

llikF(x^2, 1, 5)

model <- function(){
  model({
    fx <- llikF(time, df1, df2)
    dMean <- llikFDdf1(time, df1, df2)
    dSd <- llikFDdf2(time, df1, df2)
  })
}

et <- et(x)
et$df1 <- 1
et$df2 <- 5

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
