% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piping-model.R
\name{rxSetPipingAuto}
\alias{rxSetPipingAuto}
\title{Set the variables for the model piping automatic covarite selection}
\usage{
rxSetPipingAuto(
  thetamodelVars = rex::rex(or("tv", "t", "pop", "POP", "Pop", "TV", "T", "cov", "err",
    "eff")),
  covariateExceptions = rex::rex(start, or("wt", "sex", "crcl", "kout"), end),
  etaParts = c("eta", "ETA", "Eta", "ppv", "PPV", "Ppv", "iiv", "Iiv", "bsv", "Bsv",
    "BSV", "bpv", "Bpv", "BPV", "psv", "PSV", "Psv")
)
}
\arguments{
\item{thetamodelVars}{This is the prefixes for the theta model
variables in a regular expression}

\item{covariateExceptions}{This is a regular expression of
covariates that should always be covariates}

\item{etaParts}{This is the list of eta prefixes/post-fixes that
identify a variable as a between subject variability}
}
\value{
Nothing, called for side effects
}
\description{
Set the variables for the model piping automatic covarite selection
}
\details{
This is called once at startup to set the defaults, though you can
change this if you wish so that piping can work differently for
your individual setup
}
\author{
Matthew L. Fidler
}
