% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assertRxUi}
\alias{assertRxUi}
\alias{assertRxUiPrediction}
\alias{assertRxUiSingleEndpoint}
\alias{assertRxUiTransformNormal}
\alias{assertRxUiNormal}
\alias{assertRxUiMuRefOnly}
\alias{assertRxUiEstimatedResiduals}
\alias{assertRxUiPopulationOnly}
\alias{assertRxUiMixedOnly}
\alias{assertRxUiRandomOnIdOnly}
\title{Assert properties of the rxUi models}
\usage{
assertRxUi(model, extra = "", .var.name = .vname(model))

assertRxUiPrediction(model, extra = "", .var.name = .vname(model))

assertRxUiSingleEndpoint(model, extra = "", .var.name = .vname(model))

assertRxUiTransformNormal(model, extra = "", .var.name = .vname(model))

assertRxUiNormal(model, extra = "", .var.name = .vname(model))

assertRxUiMuRefOnly(model, extra = "", .var.name = .vname(model))

assertRxUiEstimatedResiduals(model, extra = "", .var.name = .vname(model))

assertRxUiPopulationOnly(model, extra = "", .var.name = .vname(model))

assertRxUiMixedOnly(model, extra = "", .var.name = .vname(model))

assertRxUiRandomOnIdOnly(model, extra = "", .var.name = .vname(model))
}
\arguments{
\item{model}{Model to check}

\item{extra}{Extra text to append to the error message (like
"for focei")}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
the rxUi model
}
\description{
Assert properties of the rxUi models
}
\details{
These functions have different types of assertions
\itemize{
\item \code{assertRxUi} -- Make sure this is a proper rxode2 model (if not throw error)
\item \code{assertRxUiSingleEndpoint} -- Make sure the rxode2 model is only
a single endpoint model (if not throw error)
\item \code{assertRxUiTransformNormal} -- This needs to be a normal or transformably
normal residual distribution
\item \code{assertRxUiNormal} -- This needs to be a normal residual distribution
\item \code{assertRxUiEstimatedResiduals} -- This makes sure that the
residual error parameter are estimated (not modeled).
\item \code{assertRxUiPopulationOnly} -- This makes sure the model is the
population only model (no mixed effects)
\item \code{assertRxUiMixedOnly} -- This makes sure the model is a mixed
effect model (not a population effect)
\item \code{assertRxUiPrediction} -- This makes sure the model has predictions
\item \code{assertRxUiMuRefOnly} -- This make sure that all the parameters are mu-referenced
\item \code{assertRxUiRandomOnIdOnly} -- This makes sure there is only random effects at the ID level
}
}
\examples{

one.cmt <- function() {
 ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
 })
}

assertRxUi(one.cmt)
# assertRxUi(rnorm) # will fail

assertRxUiSingleEndpoint(one.cmt)

}
\author{
Matthew L. Fidler
}
