% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological.approx.ess.R
\name{topological.approx.ess}
\alias{topological.approx.ess}
\title{Calculate the approximate Effective Sample Size (ESS) of tree topologies}
\usage{
topological.approx.ess(chains, burnin = 0, max.sampling.interval = 100,
  treedist = "PD", use.all.samples = FALSE)
}
\arguments{
\item{chains}{A list of rwty.trees objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{max.sampling.interval}{The largest sampling interval you want to use to calculate the ESS. Every sampling interval up to and including this number will be sampled. Higher is better, but also slower. In general, setting this number to 100 (the default) should be fine for most cases. However, if you get an upper bound on the ESS estimate (i.e. ESS<x) rather than a point estimate (i.e. ESS = x) then that indicates a higher max.sampling.interval would be better, because the algorithm could not find the asymptote on the autocorrelation plot with the current max.sampling.interval.}

\item{treedist}{the type of tree distance metric to use, can be 'PD' for path distance or 'RF' for Robinson Foulds distance}

\item{use.all.samples}{(TRUE/FALSE). Whether to calculate autocorrelation from all possible pairs of trees in your chain. The default is FALSE, in which case 500 samples are taken at each sampling interval. Setting this to TRUE will give you slightly more accurate ESS estimates, at the cost of potentially much longer execution times.}
}
\value{
A data frame with one row per chain, and columns describing the
approximate ESS and the name of the chain.
}
\description{
This function takes a list of rwty.trees objects, and calculates the
pseudo ESS of the trees from each chain, after removing burnin. 
The calculation uses the autocorrelation among squared topological distances between
trees to calculate an approximate ESS of tree topologies for each chain.
NB this function requires the calculation of many many
tree distances, so can take some time.
}
\examples{
\dontrun{
data(fungus)
topological.approx.ess(fungus, burnin = 20)
}
}
\keyword{distance}
\keyword{distance,}
\keyword{path}
\keyword{tree}
\keyword{treespace,}

