% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop.R
\name{vinecop_dist}
\alias{vinecop_dist}
\title{Vine copula models}
\usage{
vinecop_dist(
  pair_copulas,
  structure,
  var_types = rep("c", length(pair_copulas[[1]]) + 1)
)
}
\arguments{
\item{pair_copulas}{A nested list of '\code{\link[=bicop_dist]{bicop_dist()}}' objects, where
\code{pair_copulas[[t]][[e]]} corresponds to the pair-copula at edge \code{e} in
tree \code{t}.}

\item{structure}{an \code{rvine_structure} object, namely a compressed
representation of the vine structure, or an object that can be coerced into
one (see \code{\link[=rvine_structure]{rvine_structure()}} and \code{\link[=as_rvine_structure]{as_rvine_structure()}}). The dimension
must be \code{length(pair_copulas[[1]]) + 1}; \code{structure = NA} performs
automatic selection based on Dissman's algorithm. See \emph{Details} for partial
selection of the structure.}

\item{var_types}{variable types, a length d vector; e.g., \code{c("c", "c")} for
two continuous variables, or \code{c("c", "d")} for first variable continuous
and second discrete.}
}
\value{
Object of class \code{vinecop_dist}, i.e., a list containing:
\itemize{
\item \code{pair_copulas}, a list of lists. Each element of \code{pair_copulas} corresponds
to a tree, which is itself a list of \code{\link[=bicop_dist]{bicop_dist()}} objects.
\item \code{structure}, a compressed representation of the vine structure, or an
object that can be coerced into one (see \code{\link[=rvine_structure]{rvine_structure()}} and
\code{\link[=as_rvine_structure]{as_rvine_structure()}}).
\item \code{npars}, a \code{numeric} with the number of (effective) parameters.
\item \code{var_types} the variable types.
}
}
\description{
Create custom vine copula models by specifying the pair-copulas, structure,
and variable types.
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
  list(bicop, bicop), # pair-copulas in first tree
  list(bicop) # pair-copulas in second tree
)

# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3)

# set up vine copula model
vc <- vinecop_dist(pcs, mat)

# visualization
plot(vc)
contour(vc)

# simulate from the model
pairs(rvinecop(200, vc))
}
\seealso{
\code{\link[=rvine_structure]{rvine_structure()}}, \code{\link[=rvine_matrix]{rvine_matrix()}}, \code{\link[=vinecop]{vinecop()}},
\code{\link[=plot.vinecop_dist]{plot.vinecop_dist()}}, \code{\link[=contour.vinecop_dist]{contour.vinecop_dist()}}, \code{\link[=dvinecop]{dvinecop()}},
\code{\link[=pvinecop]{pvinecop()}}, \code{\link[=rvinecop]{rvinecop()}}
}
