% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vine_methods.R
\name{vine_predict_and_fitted}
\alias{vine_predict_and_fitted}
\alias{predict.vine}
\alias{fitted.vine}
\alias{fitted.vine}
\title{Predictions and fitted values for a vine copula model}
\usage{
\method{predict}{vine}(object, newdata, what = "pdf", n_mc = 10^4, ...)

\method{fitted}{vine}(object, what = "pdf", n_mc = 10^4, ...)
}
\arguments{
\item{object}{a \code{vine} object.}

\item{newdata}{points where the fit shall be evaluated.}

\item{what}{what to predict, either \code{"pdf"} or \code{"cdf"}.}

\item{n_mc}{number of samples used for quasi Monte Carlo integration when
\code{what = "cdf"}.}

\item{...}{unused.}
}
\value{
\code{fitted()} and \code{predict()} have return values similar to \code{\link[=dvine]{dvine()}}
and \code{\link[=pvine]{pvine()}}.
}
\description{
Predictions of the density and distribution function
for a vine copula model.
}
\examples{
x <- sapply(1:5, function(i) rnorm(50))
fit <- vine(x, copula_controls = list(family_set = "par"))
all.equal(predict(fit, x), fitted(fit))
}
