% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rViewGraph.R
\name{rViewGraph}
\alias{rViewGraph}
\alias{rViewGraph.default}
\alias{rViewGraph.Matrix}
\alias{rViewGraph.igraph}
\title{This is a function to create and start the 'Java' graph animation GUI.}
\source{
A full description of the force function and algorithm used 
is given by
C Cannings and A Thomas, 
Inference, simulation and enumeration of genealogies.
In D J Balding, M Bishop, and C Cannings, editors, The Handbook of Statistical
Genetics. Third Edition, pages 781-805. John Wiley & Sons, Ltd, 2007.
}
\usage{
rViewGraph(object, names, layout, directed, running, ...)

\method{rViewGraph}{default}(object, names = seq(max(object)),
  layout = NULL, directed = FALSE, running = TRUE, ...)

\method{rViewGraph}{Matrix}(object, names = 1:max(dim(object)),
  layout = NULL, directed = FALSE, running = TRUE, ...)

\method{rViewGraph}{igraph}(object, names = igraph::V(object)$name,
  layout = igraph::layout.random(object),
  directed = igraph::is.directed(object), running = TRUE, ...)
}
\arguments{
\item{object}{the object specifying the graph}

\item{names}{the names of the nodes}

\item{layout}{the starting positions of the vertices}

\item{directed}{indicates whether or not the graph is directed}

\item{running}{indicates whether or not to start with animation running}

\item{...}{passed along extra arguments.}
}
\value{
All versions of \code{rViewGraph} return a list of functions that control the actions of 
the viewer. None of the functions in the list take an argument.
\item{run()}{Starts the GUI running if it's not already doing so.}
\item{stop()}{Stops the GUI running if it's running.}
\item{hide()}{Stops the GUI and hides it.}
\item{show()}{Shows the GUI. If it was running when \code{hide} was called, it starts running again.}
\item{getLayout()}{Returns the coordinates of the vertices that are currently shown in the GUI. These are in the format that \code{igraph} expects for layouts.}
}
\description{
Creates and starts an animated GUI for positioning the vertices of a graph in 2 dimensions.
}
\details{
Creates and starts a 'Java' GUI showing a real time animation of a Newton-Raphson
optimization of a force function specified between the vertices of an arbitrary graph.
There are attractive forces between 
adjacent vertices and repulsive forces between all vertices.
The repulsions go smoothly to zero for a finite distance between vertices so that,
unlike some other methods, different components don't send each other off to infinity.

This is a generic function that delegates its work to specific functions depending on
the class of the first argument. It can handle an incidence matrix, a list of 
edges, and an \code{igraph} graph object.

The program is controlled by a slide bar, some buttons, the arrow, home and
shift keys, but mostly by mouse operations. All three mouse buttons are used.

\itemize{
\item The slide bar at the bottom controls the repulsive force in the energy
equation used to set the coordinates.

\item Mouse operations without shift key and without control key pressed.
\enumerate{
\item Left mouse: Drags a vertex. Vertex is free on release. 
\item Middle mouse: Drags a vertex. Vertex is fixed at release position. 
\item Right mouse: Translates the view by the amount dragged. A bit like putting
your finger on a piece of paper and moving it. 
\item Double click with any mouse button in the background: 
Resets the vertices to new random positions. 
}

\item Mouse operations with shift key but without control key pressed.
\enumerate{
\item Left mouse: Drags a vertex and the component it is in. 
Vertex and component free on release.
\item Middle mouse: Drags a vertex and the component it is in. 
Vertex and component are fixed at release positions.
\item Right mouse: Translates the positions of the vertices relative to 
the position of the canvas by the amount dragged. This is useful to center 
the picture on the canvas ready for outputting.
}

\item Mouse operations without shift key but with control key pressed.
\enumerate{
\item Left mouse: Click on a vertex to un-delete any deleted neighbours.
\item Middle mouse: Click on a vertex to delete it from the graph.
\item Double click left mouse: Replaces all deleted vertices in the graph.
\item Double click middle mouse: Deletes all vertices from the graph.
}

\item Mouse operations with shift key and with control key pressed.
\enumerate{
\item Left mouse: Click on a vertex to replace all vertices in the same component to the graph.
\item Middle mouse: Click on a vertex to delete it and the component it is in from the graph.
}

\item Key functions without shift key pressed. Mouse has to be in the picture canvas.
\enumerate{
\item Up arrow: Increases the scale of viewing by 10\%.
\item Down arrow: Decreases the scale of viewing by 10\%.
\item Left arrow: Rotates the view by 15 degrees clockwise.
\item Right arrow: Rotates the view by 15 degrees anticlockwise.
\item Home key: Undoes all scalings and rotations and places the origin at
the center of the picture canvas.
}

\item Key functions with shift key pressed. Mouse has to be in the picture canvas.
\enumerate{
\item Up arrow: Increases the vertex positions by 10\% relative to the scale of the canvas.
\item Down arrow: Decreases the vertex positions by 10\% relative to the scale of the canvas.
\item Left arrow: Rotates the vertex positions by 15 degrees clockwise relative to the canvas orientation.
\item Right arrow: Rotates the vertex positions by 15 degrees anticlockwise relative to the canvas orientation.
}
}
}
\examples{
# 
# Viewing an Erdos Renyui random graph specified by random edges.
f = sample(100,size=200,replace=TRUE)
t = sample(100,size=200,replace=TRUE)
vft = rViewGraph(cbind(f,t))
#
# Edges can also be specified in \\code{igraph} style.
e = c(t,f)
ve = rViewGraph(e)
}
\author{
Alun Thomas
}
\keyword{graph}
