% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rViewGraph.R
\name{rViewGraph}
\alias{rViewGraph}
\alias{rViewGraph.default}
\alias{rViewGraph.Matrix}
\alias{rViewGraph.igraph}
\title{This is a function to create and start the Java graph animation GUI.}
\source{
A full description of the force function and algorithm used 
is given by
C Cannings and A Thomas, 
Inference, simulation and enumeration of genealogies.
In D J Balding, M Bishop, and C Cannings, editors, The Handbook of Statistical
Genetics. Third Edition, pages 781-805. John Wiley & Sons, Ltd, 2007.
}
\usage{
rViewGraph(object, names, layout, directed, running, ...)

\method{rViewGraph}{default}(object, names = seq(max(object)),
  layout = NULL, directed = FALSE, running = TRUE, ...)

\method{rViewGraph}{Matrix}(object, names = 1:max(dim(object)),
  layout = NULL, directed = FALSE, running = TRUE, ...)

\method{rViewGraph}{igraph}(object, names = igraph::V(object)$name,
  layout = igraph::layout.random(object),
  directed = igraph::is.directed(object), running = TRUE, ...)
}
\arguments{
\item{object}{Object to plot graph for}

\item{names}{names of the nodes}

\item{layout}{layout to start}

\item{directed}{is the graph directed or not}

\item{running}{run the graph}

\item{...}{passed along extra arguments.}
}
\value{
All versions of \code{rViewGraph} return a list of functions that control the actions of 
the viewer. None of the functions in the list take an argument.
\item{run()}{Starts the GUI running if it's not already doing so.}
\item{stop()}{Stops the GUI running if it's running.}
\item{hide()}{Stops the GUI and hides it.}
\item{show()}{Shows the GUI. If it was running when \code{hide} was called, it starts running again.}
\item{getLayout()}{Returns the coordinates of the vertices that are currently shown in the GUI. These are in the format that \code{igraph} expects for layouts.}
}
\description{
Creates and starts an animated GUI for positioning the vertices of a graph in 2 dimensions.
}
\details{
Creates and starts a Java GUI showing a real time animation of a Newton-Raphson
optimization of a force function specified between the vertices of an arbitrary graph.
There are attractive forces between 
adjacent vertices and repulsive forces between all vertices.
The repulsions go smoothly to zero for a finite distance between vertices so that,
unlike some other methods, different components don't send each other off to infinity.

This is a generic function that delegates its work to specific functions depending on
the class of the first argument. It can handle an incidence matrix, a list of 
edges, and an \code{igraph} graph object.

Full information about mouse and key operations for manipulating the graph are given on
the documentation page for the Java version of 'ViewGraph' at 
<http://www-genepi.med.utah.edu/~alun/software/docs/ViewGraph.html>.
}
\examples{
# 
# Viewing an Erdos Renyui random graph specified by random edges.
f = sample(100,size=200,replace=TRUE)
t = sample(100,size=200,replace=TRUE)
vft = rViewGraph(cbind(f,t))
#
# Edges can also be specified in \\code{igraph} style.
e = c(t,f)
ve = rViewGraph(e)
}
\author{
Alun Thomas
}
\keyword{graph}
