% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body_add_vg.R
\name{body_add_vg}
\alias{body_add_vg}
\title{add a plot output as vector graphics into a Word object}
\usage{
body_add_vg(x, code, pos = "after", ...)
}
\arguments{
\item{x}{an \code{rdocx} object produced by \code{officer::read_docx}}

\item{code}{plot instructions}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{...}{arguments passed on to \code{\link{dml_docx}}.}
}
\description{
produces a vector graphics output from R plot instructions
and add the result in an Word document object produced
by \code{\link[officer]{read_docx}}.
}
\note{
The function is maintained but using it
should be avoided: Word text boxes, the elements used to put text in a graphic,
are adding extra space on top and bottom of the shape. As there is no clear rule
available to handle that, it makes impossible to compute what should be the
exact position of a text. This can affect the whole rendering of the graphic.

The function should then be considered as a failed experience. An
alternative is to use EMF format, this will not allow editing the graphic but
the display is made as vector graphic.
}
\examples{
\donttest{
library(officer)
x <- read_docx()
x <- body_add_vg(x, code = barplot(1:5, col = 2:6) )
print(x, target = "vg.docx")
}
}
