% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigsearch.R
\name{bigsearch}
\alias{bigsearch}
\title{Request to download a large number of VertNet records.}
\usage{
bigsearch(..., rfile, email, messages = TRUE, callopts = list())
}
\arguments{
\item{...}{arguments, must be named, see \code{\link[=searchbyterm]{searchbyterm()}} for details}

\item{rfile}{A name for the results file that you will download (character).
Required.}

\item{email}{An email address where you can be contacted when your records
are ready for download (character). Required.}

\item{messages}{(logical) Print progress and information messages.
Default: \code{TRUE}}

\item{callopts}{(named list) Curl arguments passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
Prints messages on progress, but returns NULL
}
\description{
Specifies a term-wise search (like \code{\link{searchbyterm}}) and requests
that all available  records be made available for download as a
tab-delimited text file.
}
\details{
\code{\link{bigsearch}} allows you to request records as a
tab-delimited text file. This is the best way to access a large number of
records, such as when your search results indicate that >1000 records are
available. You will be notified by email when your records are ready
for download.
}
\section{Reading data}{

We suggest reading data in with \code{data.table::fread()} - as it's very
fast for the sometimes large datasets
you will get from using this function, and is usually robust to
formatting issues.
}

\examples{
\dontrun{
# replace "big@search.luv" with your own email address
bigsearch(genus = "ochotona", rfile = "pikaRecords", email = "big@search.luv")

# Pass in curl options for curl debugging
bigsearch(genus = "ochotona", rfile = "pikaRecords",
  email = "big@search.luv", verbose = TRUE)

# Use more than one year query
bigsearch(class = "aves", year = c(">=1976", "<=1986"),
          rfile = "test-bigsearch1", email = "big@search.luv")
}
}
\references{
https://github.com/VertNet/webapp/wiki/The-API-search-function
}
