% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dt_rvec}
\alias{dt_rvec}
\alias{pt_rvec}
\alias{qt_rvec}
\alias{rt_rvec}
\title{Student t Distribution, Using Multiple Draws}
\usage{
dt_rvec(x, df, ncp = 0, log = FALSE)

pt_rvec(q, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qt_rvec(p, df, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rt_rvec(n, df, ncp = 0, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{df}{Degrees of freedom.
See \code{\link[stats:TDist]{stats::dt()}}.
Can be an rvec.}

\item{ncp}{Non-centrality parameter.
Default is \code{0}. See \code{\link[stats:TDist]{stats::dt()}}.
Cannot be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
t distribution, modified to work with
rvecs.
}
\details{
Functions \code{dt_rvec()}, \code{pt_rvec()},
\code{pt_rvec()} and \code{rt_rvec()} work like
base R functions \code{\link[=dt]{dt()}}, \code{\link[=pt]{pt()}},
\code{\link[=qt]{qt()}}, and \code{\link[=rt]{rt()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rt_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dt_rvec()}, \code{pt_rvec()},
\code{pt_rvec()} and \code{rt_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(-3.2, 5.3),
               c(-1.6, 2)))
dt_rvec(x, df = 4)
pt_rvec(x, df = 4)

rt_rvec(n = 2,
        df = c(3, 5),
        n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dt]{dt()}}
\item \code{\link[=pt]{pt()}}
\item \code{\link[=qt]{qt()}}
\item \code{\link[=rt]{rt()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
