% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrderbook.R
\name{getOrderbook}
\alias{getOrderbook}
\title{Get  the order book for a given symbol from a supported exchange}
\usage{
getOrderbook(
  Symbols,
  depth = 10,
  src = "poloniex",
  adjust = FALSE,
  verbose = FALSE,
  auto.assign = TRUE,
  market = "shares",
  board = "tqbr",
  api.key = "",
  env = globalenv()
)
}
\arguments{
\item{Symbols}{A character vector specifying the symbol to retrieve order book data for.}

\item{depth}{An integer value specifying the number of levels of the order book to retrieve. Defaults to 10.}

\item{src}{A character string specifying the exchange to retrieve data from. Possible values are  kraken,poloniex,tinkoff,alor, binance.}

\item{adjust}{A logical value indicating whether to adjust timestamps to match the system timezone. Defaults to FALSE.}

\item{verbose}{A logical value indicating whether to print detailed messages during the function's execution. Defaults to FALSE.}

\item{auto.assign}{A logical value indicating whether to automatically assign the resulting object to the current environment. Defaults to TRUE.}

\item{market}{A character string specifying type of market}

\item{board}{A character string specifying type of board}

\item{api.key}{A character string specifying the API key to use when retrieving data from Alor or Tinkoff. Defaults to "".}

\item{env}{environment where the data will be assigned}
}
\value{
A data.table object containing the order book data for the specified symbol.
}
\description{
This function retrieves order book information
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getOrderbook('USDTGBP', src = 'kraken')
getOrderbook('BTC_USDT', src = 'poloniex')
}
\author{
Vyacheslav Arbuzov
}
