% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.methods.R
\name{runjags.printmethods}
\alias{runjags.printmethods}
\alias{print.runjagsmodel}
\alias{print.runjagsdata}
\alias{print.runjagsinits}
\alias{print.runjagsoutput}
\alias{print.mcsestats}
\alias{print.crosscorrstats}
\alias{print.gelman.with.target}
\alias{print.dicstats}
\alias{print.runjagsbginfo}
\alias{print.failedjags}
\alias{print.rjagsoutput}
\alias{print.gelmanwithtarget}
\alias{print.runjagsstudy}
\alias{summary.runjagsstudy}
\alias{plot.runjagsstudy}
\title{Print methods for runjags helper classes}
\usage{
\method{print}{failedjags}(x, linenumbers = runjags.getOption("linenumbers"), ...)

\method{print}{runjagsmodel}(x, linenumbers = runjags.getOption("linenumbers"), ...)

\method{print}{runjagsdata}(x, linenumbers = runjags.getOption("linenumbers"), ...)

\method{print}{runjagsinits}(x, linenumbers = runjags.getOption("linenumbers"), ...)

\method{print}{runjagsoutput}(x, linenumbers = runjags.getOption("linenumbers"), ...)

\method{print}{rjagsoutput}(x, ...)

\method{print}{crosscorrstats}(x, vars = NA, digits = 5, ...)

\method{print}{mcsestats}(x, vars = NA, digits = 5, ...)

\method{print}{gelmanwithtarget}(x, vars = NA, digits = 3, ...)

\method{print}{dicstats}(x, digits = 3, ...)

\method{print}{runjagsbginfo}(x, ...)

\method{print}{runjagsstudy}(x, ...)

\method{summary}{runjagsstudy}(object, ...)

\method{plot}{runjagsstudy}(x, ...)
}
\arguments{
\item{x}{the object to be printed or converted.}

\item{linenumbers}{option to display line numbers alongside model, data and initial values output (this may be helpful for debugging).  Defualt uses the option set in \code{\link{runjags.options}}.}

\item{...}{other arguments which are passed to the default print method for some methods but ignored (with/without a warning) for others}

\item{vars}{an optional character vector of variable names.  If supplied, only variable names in the object supplied with a partial match to anything in 'vars' will be used.  Note that regular expressions are not allowed, but the caret (^) token can be used to specify the match at the start of a variable name, and a quoted vars will be matched exactly.  Default NA meaning all variables available are returned.}

\item{digits}{the number of digits to display for printed numerical output.}

\item{object}{the object to be summarised.}
}
\description{
Print methods for a number of classes that are associated with runjags objects, such as model, data and initial values files etc.
}
\references{
Matthew J. Denwood (2016). runjags: An R Package Providing Interface Utilities, Model Templates, Parallel Computing Methods and Additional Distributions for MCMC Models in JAGS. Journal of Statistical Software, 71(9), 1-25. doi:10.18637/jss.v071.i09
}
\seealso{
\code{\link{runjags-class}} for print and plot methods associated with the main runjags class
}
\keyword{methods}
