% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{any_breaker}
\alias{any_breaker}
\title{Is there any breaker in exposure?}
\usage{
any_breaker(.tbl)
}
\arguments{
\item{.tbl}{Result of \link[=expose]{exposure}, i.e. data frame with \link{exposure}
attribute.}
}
\description{
Function designed to be used as trigger in \code{\link[=act_after_exposure]{act_after_exposure()}}. Returns
\code{TRUE} if \link{exposure} attribute of \code{.tbl} has any information about data units
not obeying the rules, i.e. rule breakers.
}
\examples{
mtcars \%>\%
  expose(data_packs(. \%>\% dplyr::summarise(nrow_low = nrow(.) > 50))) \%>\%
  any_breaker()

}
\seealso{
\link{assert_any_breaker} for implicit usage of \code{any_breaker()}.
}
