% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory_alpha.R
\name{memory_alpha}
\alias{memory_alpha}
\title{Memory Alpha API}
\usage{
memory_alpha(endpoint)
}
\arguments{
\item{endpoint}{character, See details.}
}
\value{
a data frame
}
\description{
Access Star Trek content from Memory Alpha (\url{http://memory-alpha.wikia.com}).
}
\details{
The content returned is always a data frame. The structure changes slightly depending on the nature of the endpoint,
but results from different endpoints can be merged easily.

\subsection{Portals}{
At the highest level, passing \code{enpoind = "portals"} returns a data frame listing the available Memory Alpha portals supported by \code{rtrek}.
A column of relative URLs is also included for reference, but can be ignored.
}

\subsection{Portal Categories}{
In all other cases, the endpoint string must begin with one of the valid portal IDs.
Passing only the ID returns a data frame with IDs and relative URLs associated with the available categories in the specific portal.
There are two additional columns, \code{group} and \code{subgroup}, that may provide additional grouping context for the entry IDs in larger tables.
As with the relative URLs, you do not have to make explicit use of these variables.
\cr\cr
Selecting a specific category within a portal is done by appending the portal ID in \code{endpoint} with the category ID, separated by a forward slash.
You can append nested subcategory IDs with forward slashes, provided they subcategories exist.
}

\subsection{Articles}{
When the endpoint is neither a top-level portal or one of a portal's categories (or subcategories, if available), it is an article.
An article is a terminal node, meaning you cannot nest further. An article will be any entry whose URL does not begin with \code{Category:}.
In this case, the content returned is still a data frame for consistency, but differs substantially from the results of non-terminal endpoints.
\cr\cr
Memory Alpha is not a database containing convenient tables. Articles comprise the bulk of what Memory Alpha has to offer.
They are not completely unstructured text, but are loosely structured.
Some assumptions are made and \code{memory_alpha} returns a data frame containing article text and links.
It is up to the user what to do with this information, e.g., performing text analyses.
}

\subsection{Additional notes}{
The \code{url} column included in results for context uses relative paths to save space. The full URLs all begin the same.
To visit a URL directly, prepend it with \code{http://memory-alpha.wikia.com/wiki/}.
\cr\cr
Also note that once you know the relative URL for an article, e.g., \code{"Worf"},
you do not need to traverse through one of the portals using an \code{endpoint} string to retrieve its content.
You can instead use \code{ma_article("Worf")}.
\cr\cr
\code{memory_alpha} provides an overview perspective on how content available at Memory Alpha is organized and can be searched for through
a variety of hierarchical layouts. And in some cases this structure that can be obtained in table form can be useful as data or metadata
in itself. Alternatively, \code{ma_article} is focused exclusively on pulling back content from known articles.
}
}
\examples{
memory_alpha("portals") # show available portals
if(has_internet()){
  memory_alpha("people") # show portal categories for People portal
  memory_alpha("people/Klingons") # show people in Klingons subcategory
  memory_alpha("people/Klingons/Worf") # return terminal article content
}
}
\seealso{
\code{\link{ma_article}}, \code{\link{memory_beta}}
}
