% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneFACTORplot.r
\name{oneFACTORplot}
\alias{oneFACTORplot}
\title{Bar plot of the relative gene expression (\eqn{\Delta C_T} method) from the \code{qpcrANOVARE} output of a one-factor experiment data}
\usage{
oneFACTORplot(
  res,
  width = 0.4,
  fill = "skyblue",
  y.axis.adjust = 0.5,
  y.axis.by = 2,
  errorbar = "se",
  show.letters = TRUE,
  letter.position.adjust = 0.1,
  ylab = "Relative Expression",
  xlab = "none",
  fontsize = 12,
  fontsizePvalue = 5,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5
)
}
\arguments{
\item{res}{an FC data frame object created by \code{qpcrANOVARE(x)$Result} function on a one factor data such as \code{data_1factor}.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify a fill color.}

\item{y.axis.adjust}{a negative or positive number for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length.}

\item{errorbar}{Type of error bar, can be \code{se} or \code{ci}.}

\item{show.letters}{a logical variable. If TRUE, mean grouping letters are added to the bars.}

\item{letter.position.adjust}{adjust the distance between the grouping letters to the error bars.}

\item{ylab}{the title of the y axis.}

\item{xlab}{the title of the x axis.}

\item{fontsize}{size of all fonts  of the plot.}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}
}
\value{
Bar plot of the average fold change for target genes along with the significance and the 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression of a gene along with the standard error (se), 95\% confidence interval (ci) and significance. \code{oneFACTORplot} is mainly useful for a one-factor experiment with more than two levels.
}
\details{
The \code{oneFACTORplot} function generates the bar plot of the average fold change for target genes along with the significance and the 95\% confidence interval as error bars.
}
\examples{

# Before plotting, the result needs to be extracted as below:
res <- qpcrANOVARE(data_1factor, numberOfrefGenes = 1)$Result

# Bar plot
oneFACTORplot(res,
         width = 0.2,
         fill = "skyblue",
         y.axis.adjust = 0,
         y.axis.by = 0.2,
         errorbar = "se",
         show.letters = TRUE,
         letter.position.adjust = 0.05,
         ylab = "Relative Expression",
         xlab = "Factor Levels",
         fontsize = 12)


}
\author{
Ghader Mirzaghaderi
}
