% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelines_statuses.R
\name{get_status}
\alias{get_status}
\alias{get_reblogged_by}
\alias{get_favourited_by}
\title{View information about a specific status}
\usage{
get_status(id, instance = NULL, token = NULL, anonymous = FALSE, parse = TRUE)

get_reblogged_by(
  id,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  parse = TRUE
)

get_favourited_by(
  id,
  instance = NULL,
  token = NULL,
  anonymous = FALSE,
  parse = TRUE
)
}
\arguments{
\item{id}{character, local ID of a status in the database}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{token}{user bearer token (read from file by default)}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
a status or a list of users
}
\description{
Query the instance for information about a specific status. \link{get_status} returns complete information of a status.
\link{get_reblogged_by} returns who boosted a given status. \link{get_favourited_by} returns who favourited a given status.
}
\examples{
\dontrun{
get_status(id = "109326579599502650")
get_reblogged_by(id = "109326579599502650")
get_favourited_by(id = "109326579599502650")
}
}
