% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{auth_setup}
\alias{auth_setup}
\title{Authenticate with a Mastodon instance}
\usage{
auth_setup(
  instance = NULL,
  type = NULL,
  name = NULL,
  path = NULL,
  clipboard = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{instance}{a public instance of Mastodon (e.g., mastodon.social).}

\item{type}{Either "public" to create a public authentication or "user" to
create authentication for your user (e.g., if you want to post from R or
query your followers).}

\item{name}{give the token a name, in case you want to store more than one.}

\item{path}{path to store the token in. The default is to store tokens in the
path returned by \code{tools::R_user_dir("rtoot", "config")}.}

\item{clipboard}{logical, whether to export the token to the clipboard}

\item{verbose}{logical whether to display messages}
}
\value{
A bearer token
}
\description{
Authenticate with a Mastodon instance
}
\details{
If either \code{name} or \code{path} are set to \code{FALSE}, the token is only
returned and not saved. If you would like to save your token as an environment variable,
please set \code{clipboard} to \code{TRUE}. Your token will be copied to clipboard in the environment variable
format. Please paste it into your environment file, e.g. ".Renviron", and restart
your R session.
}
\examples{
\dontrun{
auth_setup("mastodon.social", "public")
}
}
\seealso{
\code{\link[=verify_credentials]{verify_credentials()}}, \code{\link[=convert_token_to_envvar]{convert_token_to_envvar()}}
}
