% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_cols_by_cuts}
\alias{split_cols_by_cuts}
\alias{split_rows_by_cuts}
\alias{split_cols_by_cutfun}
\alias{split_cols_by_quartiles}
\alias{split_rows_by_quartiles}
\alias{split_rows_by_cutfun}
\title{Split on static or dynamic cuts of the data}
\usage{
split_cols_by_cuts(
  lyt,
  var,
  cuts,
  cutlabels = NULL,
  split_label = var,
  nested = TRUE,
  cumulative = FALSE,
  show_colcounts = FALSE,
  colcount_format = NULL
)

split_rows_by_cuts(
  lyt,
  var,
  cuts,
  cutlabels = NULL,
  split_label = var,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  cumulative = FALSE,
  label_pos = "hidden",
  section_div = NA_character_
)

split_cols_by_cutfun(
  lyt,
  var,
  cutfun = qtile_cuts,
  cutlabelfun = function(x) NULL,
  split_label = var,
  nested = TRUE,
  extra_args = list(),
  cumulative = FALSE,
  show_colcounts = FALSE,
  colcount_format = NULL
)

split_cols_by_quartiles(
  lyt,
  var,
  split_label = var,
  nested = TRUE,
  extra_args = list(),
  cumulative = FALSE,
  show_colcounts = FALSE,
  colcount_format = NULL
)

split_rows_by_quartiles(
  lyt,
  var,
  split_label = var,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  label_pos = "hidden",
  section_div = NA_character_
)

split_rows_by_cutfun(
  lyt,
  var,
  cutfun = qtile_cuts,
  cutlabelfun = function(x) NULL,
  split_label = var,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  label_pos = "hidden",
  section_div = NA_character_
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{var}{(\code{string})\cr variable name.}

\item{cuts}{(\code{numeric})\cr cuts to use.}

\item{cutlabels}{(\code{character} or \code{NULL})\cr labels for the cuts.}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{cumulative}{(\code{flag})\cr whether the cuts should be treated as cumulative. Defaults to \code{FALSE}.}

\item{show_colcounts}{(\code{logical(1)})\cr should column counts be displayed at the level
facets created by this split. Defaults to \code{FALSE}.}

\item{colcount_format}{(\code{character(1)})\cr if \code{show_colcounts} is \code{TRUE}, the
format which should be used to display column counts for facets generated by
this split. Defaults to \code{"(N=xx)"}.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{cutfun}{(\code{function})\cr function which accepts the \emph{full vector} of \code{var} values and returns cut points to be
used (via \code{cut}) when splitting data during tabulation.}

\item{cutlabelfun}{(\code{function})\cr function which returns either labels for the cuts or \code{NULL} when passed the
return value of \code{cutfun}.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Create columns (or row splits) based on values (such as quartiles) of \code{var}.
}
\details{
For dynamic cuts, the cut is transformed into a static cut by \code{\link[=build_table]{build_table()}} \emph{based on the full dataset},
before proceeding. Thus even when nested within another split in column/row space, the resulting split will reflect
the overall values (e.g., quartiles) in the dataset, NOT the values for subset it is nested under.
}
\examples{
library(dplyr)

# split_cols_by_cuts
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by_cuts("AGE",
    split_label = "Age",
    cuts = c(0, 25, 35, 1000),
    cutlabels = c("young", "medium", "old")
  ) \%>\%
  analyze(c("BMRKR2", "STRATA2")) \%>\%
  append_topleft("counts")

tbl <- build_table(lyt, ex_adsl)
tbl

# split_rows_by_cuts
lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by_cuts("AGE",
    split_label = "Age",
    cuts = c(0, 25, 35, 1000),
    cutlabels = c("young", "medium", "old")
  ) \%>\%
  analyze(c("BMRKR2", "STRATA2")) \%>\%
  append_topleft("counts")


tbl2 <- build_table(lyt2, ex_adsl)
tbl2

# split_cols_by_quartiles

lyt3 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_cols_by_quartiles("AGE", split_label = "Age") \%>\%
  analyze(c("BMRKR2", "STRATA2")) \%>\%
  append_topleft("counts")

tbl3 <- build_table(lyt3, ex_adsl)
tbl3

# split_rows_by_quartiles
lyt4 <- basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by_quartiles("AGE", split_label = "Age") \%>\%
  analyze("BMRKR2") \%>\%
  append_topleft(c("Age Quartiles", " Counts BMRKR2"))

tbl4 <- build_table(lyt4, ex_adsl)
tbl4

# split_cols_by_cutfun
cutfun <- function(x) {
  cutpoints <- c(
    min(x),
    mean(x),
    max(x)
  )

  names(cutpoints) <- c("", "Younger", "Older")
  cutpoints
}

lyt5 <- basic_table() \%>\%
  split_cols_by_cutfun("AGE", cutfun = cutfun) \%>\%
  analyze("SEX")

tbl5 <- build_table(lyt5, ex_adsl)
tbl5

# split_rows_by_cutfun
lyt6 <- basic_table() \%>\%
  split_cols_by("SEX") \%>\%
  split_rows_by_cutfun("AGE", cutfun = cutfun) \%>\%
  analyze("BMRKR2")

tbl6 <- build_table(lyt6, ex_adsl)
tbl6

}
\author{
Gabriel Becker
}
