% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{split_rows_by_multivar}
\alias{split_rows_by_multivar}
\title{Associate Multiple Variables with Rows}
\usage{
split_rows_by_multivar(
  lyt,
  vars,
  split_fun = NULL,
  split_label = "",
  varlabels = vars,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  child_labels = c("default", "visible", "hidden"),
  indent_mod = 0L,
  section_div = NA_character_,
  extra_args = list()
)
}
\arguments{
\item{lyt}{layout object pre-data used for tabulation}

\item{vars}{character vector. Multiple variable names.}

\item{split_fun}{function/NULL. custom splitting function See
\code{\link{custom_split_funs}}}

\item{split_label}{string. Label string to be associated with the table
generated by the split. Not to be confused with labels assigned to each
child (which are based on the data and type of split during tabulation).}

\item{varlabels}{character vector. Labels for \code{vars}}

\item{format}{\code{FormatSpec}. Format associated with this split. Formats can be
declared via strings (\code{"xx.x"}) or function. In cases such as
\code{analyze} calls, they can character vectors or lists of functions.}

\item{na_str}{character(1). String that should be displayed when the value of \code{x} is missing.
Defaults to \code{"NA"}.}

\item{nested}{boolean. Should this layout instruction be applied within the
existing layout structure \emph{if possible} (\code{TRUE}, the default) or as a
new top-level element (`FALSE). Ignored if it would nest a split underneath
analyses, which is not allowed.}

\item{child_labels}{string. One of \code{"default"}, \code{"visible"},
\code{"hidden"}. What should the display behavior be for the  labels (i.e.
label rows) of the children of this split. Defaults to \code{"default"}
which flags the label row as visible only if the child has 0 content rows.}

\item{indent_mod}{numeric. Modifier for the default indent position for the
structure created by this function(subtable, content table, or row)
\emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{section_div}{character(1). String which should be repeated as a section
divider after each group defined by this split instruction, or
\code{NA_character_} (the default) for no section divider.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation
function. Element position in the list corresponds to the children of this
split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further
layouting functions, and to \code{build_table}.
}
\description{
When we need rows to reflect different variables rather than different
levels of a single variable, we use \code{split_rows_by_multivar}.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by_multivar(c("SEX", "STRATA1")) \%>\%
  summarize_row_groups() \%>\%
  analyze(c("AGE", "SEX"))

tbl <- build_table(lyt, DM)
tbl

}
\seealso{
\code{\link[=split_rows_by]{split_rows_by()}} for typical row splitting, and
\code{\link[=split_cols_by_multivar]{split_cols_by_multivar()}} to perform the same type of split on a column basis.
}
