% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{lyt_args}
\alias{lyt_args}
\title{Layouting function argument conventions}
\usage{
lyt_args(
  lyt,
  var,
  vars,
  label,
  labels_var,
  varlabels,
  varnames,
  split_format,
  split_na_str,
  nested,
  format,
  cfun,
  cformat,
  cna_str,
  split_fun,
  split_name,
  split_label,
  afun,
  inclNAs,
  valorder,
  ref_group,
  compfun,
  label_fstr,
  child_labels,
  extra_args,
  name,
  cuts,
  cutlabels,
  cutfun,
  cutlabelfun,
  cumulative,
  indent_mod,
  show_labels,
  label_pos,
  var_labels,
  cvar,
  table_names,
  topleft,
  align,
  page_by,
  page_prefix,
  format_na_str,
  section_div,
  na_str,
  show_colcounts,
  colcount_format
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{var}{(\code{string})\cr variable name.}

\item{vars}{(\code{character})\cr vector of variable names.}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{labels_var}{(\code{string})\cr name of variable containing labels to be displayed for the values of \code{var}.}

\item{varlabels}{(\code{character})\cr vector of labels for \code{vars}.}

\item{varnames}{(\code{character})\cr vector of names for \code{vars} which will appear in pathing. When \code{vars} are all
unique this will be the variable names. If not, these will be variable names with suffixes as necessary to enforce
uniqueness.}

\item{split_format}{(\code{string}, \code{function}, or \code{list})\cr default format associated with the split being created.}

\item{split_na_str}{(\code{character})\cr NA string vector for use with \code{split_format}.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{cfun}{(\code{list}, \code{function}, or \code{NULL})\cr tabulation function(s) for creating content rows. Must accept \code{x}
or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional
arguments accepted by analysis functions. See \code{\link[=analyze]{analyze()}}.}

\item{cformat}{(\code{string}, \code{function}, or \code{list})\cr format for content rows.}

\item{cna_str}{(\code{character})\cr NA string for use with \code{cformat} for content table.}

\item{split_fun}{(\code{function} or \code{NULL})\cr custom splitting function. See \link{custom_split_funs}.}

\item{split_name}{(\code{string})\cr name associated with the split (for pathing, etc.).}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{afun}{(\code{function})\cr analysis function. Must accept \code{x} or \code{df} as its first parameter. Can optionally take
other parameters which will be populated by the tabulation framework. See Details in \code{\link[=analyze]{analyze()}}.}

\item{inclNAs}{(\code{logical})\cr whether NA observations in the \code{var} variable(s) should be included when performing
the analysis. Defaults to \code{FALSE}.}

\item{valorder}{(\code{character})\cr the order that the split children should appear in resulting table.}

\item{ref_group}{(\code{character})\cr value of \code{var} to be taken as the \code{ref_group}/control to be compared against.}

\item{compfun}{(\code{function} or \code{string})\cr the comparison function which accepts the analysis function outputs for
two different partitions and returns a single value. Defaults to subtraction. If a string, taken as the name of a
function.}

\item{label_fstr}{(\code{string})\cr a \code{sprintf} style format string. For non-comparison splits, it can contain up to
one \code{"\\\%s"} which takes the current split value and generates the row/column label. For comparison-based splits
it can contain up to two \code{"\\\%s"}.}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{name}{(\code{string})\cr name of the split/table/row being created. Defaults to the value of the
corresponding label, but is not required to be.}

\item{cuts}{(\code{numeric})\cr cuts to use.}

\item{cutlabels}{(\code{character} or \code{NULL})\cr labels for the cuts.}

\item{cutfun}{(\code{function})\cr function which accepts the \emph{full vector} of \code{var} values and returns cut points to be
used (via \code{cut}) when splitting data during tabulation.}

\item{cutlabelfun}{(\code{function})\cr function which returns either labels for the cuts or \code{NULL} when passed the
return value of \code{cutfun}.}

\item{cumulative}{(\code{flag})\cr whether the cuts should be treated as cumulative. Defaults to \code{FALSE}.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{show_labels}{(\code{string})\cr whether the variable labels corresponding to the variable(s) in \code{vars}
should be visible in the resulting table.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{var_labels}{(\code{character})\cr vector of labels for one or more variables.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{table_names}{(\code{character})\cr names for the tables representing each atomic analysis. Defaults to \code{var}.}

\item{topleft}{(\code{character})\cr override values for the "top left" material to be displayed during printing.}

\item{align}{(\code{string} or \code{NULL})\cr alignment the value should be rendered with. Defaults to \code{"center"} if
\code{NULL} is used. See \code{\link[formatters:list_formats]{formatters::list_valid_aligns()}} for all currently supported alignments.}

\item{page_by}{(\code{flag})\cr whether pagination should be forced between different children resulting from this
split. An error will occur if the selected split does not contain at least one value that is not \code{NA}.}

\item{page_prefix}{(\code{string})\cr prefix to be appended with the split value when forcing pagination between
the children of a split/table.}

\item{format_na_str}{(\code{string})\cr string which should be displayed when formatted if this cell's value(s)
are all \code{NA}.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{show_colcounts}{(\code{logical(1)})\cr should column counts be displayed at the level
facets created by this split. Defaults to \code{FALSE}.}

\item{colcount_format}{(\code{character(1)})\cr if \code{show_colcounts} is \code{TRUE}, the
format which should be used to display column counts for facets generated by
this split. Defaults to \code{"(N=xx)"}.}
}
\value{
No return value.
}
\description{
Layouting function argument conventions
}
\seealso{
Other conventions: 
\code{\link{compat_args}()},
\code{\link{constr_args}()},
\code{\link{gen_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
\keyword{internal}
