% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{compat_args}
\alias{compat_args}
\title{Compatibility argument conventions}
\usage{
compat_args(.lst, row.name, format, indent, label, inset)
}
\arguments{
\item{.lst}{(\code{list})\cr an already-collected list of arguments to be used instead of the elements of \code{...}.
Arguments passed via \code{...} will be ignored if this is specified.}

\item{row.name}{(\code{string} or \code{NULL})\cr row name. If \code{NULL}, an empty string is used as \code{row.name} of the
\code{\link[=rrow]{rrow()}}.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr the format label (string) or formatter function to apply to the
cell values passed via \code{...}. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for currently supported format labels.}

\item{indent}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{inset}{(\code{integer(1)})\cr the table inset for the row or table being constructed. See
\code{\link[formatters:table_inset]{formatters::table_inset()}} for details.}
}
\value{
No return value.
}
\description{
Compatibility argument conventions
}
\seealso{
Other conventions: 
\code{\link{constr_args}()},
\code{\link{gen_args}()},
\code{\link{lyt_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
