% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_as_flextable.R
\name{tt_to_flextable}
\alias{tt_to_flextable}
\alias{theme_docx_default}
\alias{theme_html_default}
\alias{word_mm_to_pt}
\title{Create a \code{flextable} from an \code{rtables} table}
\usage{
tt_to_flextable(
  tt,
  theme = theme_docx_default(),
  border = flextable::fp_border_default(width = 0.5),
  indent_size = NULL,
  titles_as_header = TRUE,
  bold_titles = TRUE,
  footers_as_text = FALSE,
  counts_in_newline = FALSE,
  paginate = FALSE,
  fontspec = NULL,
  lpp = NULL,
  cpp = NULL,
  ...,
  colwidths = NULL,
  tf_wrap = !is.null(cpp),
  max_width = cpp,
  total_width = 10
)

theme_docx_default(
  font = "Arial",
  font_size = 9,
  cell_margins = c(word_mm_to_pt(1.9), word_mm_to_pt(1.9), 0, 0),
  bold = c("header", "content_rows", "label_rows", "top_left"),
  bold_manual = NULL,
  border = flextable::fp_border_default(width = 0.5)
)

theme_html_default(
  font = "Courier",
  font_size = 9,
  cell_margins = 0.2,
  remove_internal_borders = "label_rows",
  border = flextable::fp_border_default(width = 1, color = "black")
)

word_mm_to_pt(mm)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{theme}{(\code{function} or \code{NULL})\cr A theme function that is designed internally as a function of a \code{flextable}
object to change its layout and style. If \code{NULL}, it will produce a table similar to \code{rtables} default. Defaults
to \code{theme_docx_default()} that is a classic Word output. See details for more information.}

\item{border}{(\code{flextable::fp_border()})\cr border style. Defaults to \code{flextable::fp_border_default(width = 0.5)}.}

\item{indent_size}{(\code{numeric(1)})\cr if \code{NULL}, the default indent size of the table (see \code{\link[formatters:matrix_form]{formatters::matrix_form()}}
\code{indent_size}, default is 2) is used. To work with \code{docx}, any size is multiplied by 1 mm (2.83 pt) by default.}

\item{titles_as_header}{(\code{flag})\cr defaults to \code{TRUE} for \code{\link[=tt_to_flextable]{tt_to_flextable()}}, so the table is self-contained
as it makes additional header rows for \code{\link[formatters:title_footer]{formatters::main_title()}} string and \code{\link[formatters:title_footer]{formatters::subtitles()}} character
vector (one per element). \code{FALSE} is suggested for \code{\link[=export_as_docx]{export_as_docx()}}. This adds titles and subtitles as a text
paragraph above the table. The same style is applied.}

\item{bold_titles}{(\code{flag} or \code{integer})\cr defaults to \code{TRUE} for \code{\link[=tt_to_flextable]{tt_to_flextable()}}, so the titles are bold. If
it is one or more integers, those lines will be bold.}

\item{footers_as_text}{(\code{flag})\cr defaults to \code{FALSE} for \code{\link[=tt_to_flextable]{tt_to_flextable()}}, so the table is self-contained with
the \code{flextable} definition of footnotes. \code{TRUE} is used for \code{\link[=export_as_docx]{export_as_docx()}} to add the footers as a new
paragraph after the table. The same style is applied, but with a smaller font.}

\item{counts_in_newline}{(\code{flag})\cr defaults to \code{FALSE}. In \code{rtables} text printing (\code{\link[formatters:tostring]{formatters::toString()}}),
the column counts, i.e. \code{(N=xx)}, are always on a new line. For \code{docx} exports it could be necessary to print it
on the same line.}

\item{paginate}{(\code{flag})\cr when exporting \code{.docx} documents using \code{export_as_docx}, we suggest relying on the
Microsoft Word pagination system. If \code{TRUE}, this option splits \code{tt} into different "pages" as multiple
\code{flextables}. Cooperation between the two mechanisms is not guaranteed. Defaults to \code{FALSE}.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[formatters:font_spec]{font_spec()}}.}

\item{lpp}{(\code{numeric(1)})\cr maximum lines per page including (re)printed header and context rows.}

\item{cpp}{(\code{numeric(1)} or \code{NULL})\cr width (in characters) of the pages for horizontal pagination.
\code{NA} (the default) indicates \code{cpp} should be inferred from the page size; \code{NULL} indicates no horizontal
pagination should be done regardless of page size.}

\item{...}{additional parameters passed to methods or tabulation functions.}

\item{colwidths}{(\code{numeric})\cr a vector of column widths for use in vertical pagination.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{total_width}{(\code{numeric(1)})\cr total width (in inches) for the resulting flextable(s). Defaults to 10.}

\item{font}{(\code{string})\cr defaults to \code{"Arial"}. If the font is not available, \code{flextable} default is used.
Please consider consulting the family column from \code{systemfonts::system_fonts()}.}

\item{font_size}{(\code{integer(1)})\cr font size. Defaults to 9.}

\item{cell_margins}{(\code{numeric(1)} or \code{numeric(4)})\cr a numeric or a vector of four numbers indicating
\code{c("left", "right", "top", "bottom")}. It defaults to 0 for top and bottom, and to 0.19 \code{mm} in word \code{pt}
for left and right.}

\item{bold}{(\code{character})\cr parts of the table text that should be in bold. Can be any combination of
\code{c("header", "content_rows", "label_rows", "top_left")}. The first one renders all column names bold
(not \code{topleft} content). The second and third option use \code{\link[formatters:make_row_df]{formatters::make_row_df()}} to render content or/and
label rows as bold.}

\item{bold_manual}{(named \code{list} or \code{NULL})\cr list of index lists. See example for needed structure. Accepted
groupings/names are \code{c("header", "body")}.}

\item{remove_internal_borders}{(\code{character})\cr defaults to \code{"label_rows"}. Remove internal borders between rows.
Currently there are no other options and can be turned off by providing any character value.}

\item{mm}{(\code{numeric(1)})\cr the value in mm to transform to pt.}
}
\value{
A \code{flextable} object.
}
\description{
Principally used for export (\code{\link[=export_as_docx]{export_as_docx()}}), this function produces a \code{flextable}
from an \code{rtables} table. If \code{theme = NULL}, \code{rtables}-like style will be used. Otherwise,
\code{\link[=theme_docx_default]{theme_docx_default()}} will produce a \code{.docx}-friendly table.
}
\details{
Themes can also be extended when you need only a minor change from a default style. You can either
add your own theme to the theme call (e.g. \code{c(theme_docx_default(), my_theme)}) or create a new
theme like shown in the examples. Please pay attention to the parameters' inputs as they are relevant
for this to work properly.
Indeed, it is possible to use some hidden values for building your own theme (hence the need of \code{...}).
In particular, \code{tt_to_flextable} sends in the following variable: \code{tbl_row_class = make_row_df(tt)$node_class}.
This is ignored if not used in the theme. See \code{theme_docx_default} for an example on own to retrieve
these values and how to use them.
}
\section{Functions}{
\itemize{
\item \code{theme_docx_default()}: Main theme function for \code{\link[=export_as_docx]{export_as_docx()}}.

\item \code{theme_html_default()}: Theme function for html outputs.

\item \code{word_mm_to_pt()}: Padding helper functions to transform mm to pt.

}}
\examples{
analysisfun <- function(x, ...) {
  in_rows(
    row1 = 5,
    row2 = c(1, 2),
    .row_footnotes = list(row1 = "row 1 - row footnote"),
    .cell_footnotes = list(row2 = "row 2 - cell footnote")
  )
}

lyt <- basic_table(
  title = "Title says Whaaaat", subtitles = "Oh, ok.",
  main_footer = "ha HA! Footer!"
) \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = analysisfun)

tbl <- build_table(lyt, ex_adsl)

\dontshow{if (require(flextable)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(flextable)
# example code

# rtables style
tt_to_flextable(tbl, theme = NULL)

tt_to_flextable(tbl, theme = theme_docx_default(font_size = 6))

# Example with multiple themes (only extending the docx default!)
my_theme <- function(x, ...) {
  border_inner(x, part = "body", border = flextable::fp_border_default(width = 0.5))
}
flx <- tt_to_flextable(tbl, theme = c(theme_docx_default(), my_theme))
\dontshow{\}) # examplesIf}
\dontshow{if (require(flextable)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(flextable)
# Custom theme
special_bold <- list(
  "header" = list("i" = 1, "j" = c(1, 3)),
  "body" = list("i" = c(1, 2), "j" = 1)
)
custom_theme <- theme_docx_default(
  font_size = 10,
  font = "Brush Script MT",
  border = flextable::fp_border_default(color = "pink", width = 2),
  bold = NULL,
  bold_manual = special_bold
)
tt_to_flextable(tbl,
  border = flextable::fp_border_default(color = "pink", width = 2),
  theme = custom_theme
)

# Extending themes
my_theme <- function(font_size = 6) { # here can pass additional arguments for default theme
  function(flx, ...) {
    # First apply theme_docx_default
    flx <- theme_docx_default(font_size = font_size)(flx, ...)

    # Then apply additional styling
    flx <- border_inner(flx, part = "body", border = flextable::fp_border_default(width = 0.5))

    return(flx)
  }
}
flx <- tt_to_flextable(tbl, theme = my_theme())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=export_as_docx]{export_as_docx()}}

\code{\link[=export_as_docx]{export_as_docx()}}
}
